// Persistence Of Vision raytracer version 3.5 sample file.
//
// -w320 -h240
// -w800 -h600 +a0.3

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"
/*
camera {
  location <0, 105, 50>
  up <0, 0, 1>
  sky <0, 0, 1>
  look_at <0, 0, 0>
}*/








light_source { <20000, 50000, 100000> color rgb 0.80*<1,1,1> }
light_source { <-20000, 50000, 100000> color rgb 0.30*<1,1,1> }

background { color rgb <0.900, 0.950, 1.000>  }
#declare plotSz = 1/3 ;
#include "scene.inc"

#declare maxSize = (maxX - minX)*escala;
#declare maxMag = 1.0;
object{ 
	union{
		/*object{ plate 
			translate <-(maxSize)/2.0,-(maxSize)/2.0,0 >
			scale <1,1,0.01*maxSize>
			rotate 60*z 
			texture{
				pigment {color rgb <1.000, 0.970, 0.9000> } 
				finish  {diffuse 0.8 ambient 0.2}
			}		
		}*/
		object{ 
		sticks
			translate <-(maxSize)/2.0,-(maxSize)/2.0,0 >
			scale <1,1,(plotSz*maxSize)/maxMag>
			rotate 60*z
			texture{
				pigment {color rgb <0.100, 0.170, 0.1000> } 
				finish  {diffuse 0.8 ambient 0.2}
			}		
		}
		object{
			bolinhas
			translate <-(maxSize)/2.0,-(maxSize)/2.0,0 >
			rotate 60*z
			texture{
				pigment {color rgb <1.000, 0.070, 0.0000> } 
				finish  {diffuse 0.8 ambient 0.2}
			}		
		}
	}
	
}

#declare camera_disp = 3*maxSize*<-0.3,0.4,0.3>;
#declare camera_radius = 0.7*maxSize;
#declare camera_focus = <0,0,0> ;
#declare image_rel_width = image_width;
#declare image_rel_height = image_height;


#include "camera.inc"