#! /bin/bash

# Executes {compute_normals} in a test directory, and does the 
# post-processing stuff.

dir="$1"; shift

BIN_DIR="${HOME}/Raab/Versoes_${VERSAO_RAAB}/bin"

paramfile="${dir}/params_tab.txt"

if [[ ! -d ${dir} ]] ; then
  echo "not a directory: ${dir}" 1>&2
  exit 1
fi

if [[ ! -r ${paramfile} ]] ; then
  echo "parameter file not found: ${paramfile}" 1>&2
  exit 1
fi

outdir="${dir}/OUT"
prefix="t"

echo "processing test ${paramfile} ..." 1>&2

mkdir -p ${outdir}

echo "***************************************************************************"
echo ${BIN_DIR}/compute_normals_from_table \
  -prefix ${outdir}/${prefix} \
  `cat ${paramfile} | sed -e 's:[#].*$::'` 
echo "***************************************************************************"

# echo " " > .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libraab >> .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libimg >> .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/compute_normals >> .temp1
# echo run \
#   -prefix ${outdir}/${prefix} \
#   `cat ${paramfile} | sed -e 's:[#].*$::'` \
#   >> .temp1
# gdb -exec=${BIN_DIR}/compute_normals -x .temp1

rvalgrind --tool=memcheck  --leak-check=full --show-reachable=yes --log-file="debug_test.txt" \
  ${BIN_DIR}/compute_normals_from_table \
  -prefix ${outdir}/${prefix} \
  `cat ${paramfile} | sed -e 's:[#].*$::'`

for canal in 0 1 2 3 ; do
  if [[ -r ${outdir}/${prefix}_${canal}_normals.fni ]] ; then
    ${BIN_DIR}/normal_map_to_pnm \
      ${outdir}/${prefix}_${canal}_normals.fni \
      ${outdir}/${prefix}_${canal}_normals.ppm
  fi
done

for f in \
  {0,1,2,3}_normals.ppm \
  gauge_mask.ppm \
  weights.pgm \
  L_{??}.ppm \
  K_{??}.ppm \
  albedo.ppm ; \
do
  if [[ -r ${outdir}/${prefix}_${f} ]] ; then
    convert ${outdir}/${prefix}_${f} \
      ${outdir}/${prefix}_${f%%.*}.png
  fi
done

display -filter box -resize '200%' ${outdir}/${prefix}_*.png
