#!/bin/bash
prefix="$1"; shift
mask_file="$1"; shift
gauge_suffix="$1"; shift
gabs=( `shopt -s nullglob; echo ${prefix}f-*_${gauge_suffix}.ppm` )

tmp=/tmp/$$


if [[ ! -s ${mask_file} ]] ; then
	echo "${mask_file} does not exist !" 
	exit 1
fi

width=`identify ${mask_file}| cut -d" " -f3 | cut -d"x" -f1 `
height=`identify ${mask_file}| cut -d" " -f3 | cut -d"x" -f2 `


ppmmake 'rgbi:1/1/1'  ${width} ${height} > ${tmp}-white.ppm
pnmxarith -subtract ${tmp}-white.ppm ${mask_file} > ${tmp}-inv-mask.ppm

#display ${tmp}-inv-mask.ppm ${tmp}-white.ppm


for gab in ${gabs[@]} ; do
	pnmxarith -multiply ${tmp}-inv-mask.ppm ${gab} | ppmtopgm | pgmnorm |  convert PGM:- ${gab%.*}-maskout.png
	pnmxarith -multiply ${mask_file} ${gab} | ppmtopgm | pgmnorm | convert PGM:- ${gab%.*}-maskin.png
done

