#!/bin/bash
prefix="$1"; shift
intag=( "$1" "$2" ); shift ; shift
channel="$1"; shift
numlights="$1"; shift
for i in 0 1 ; do
	#roda mix_tables com uma tabela só para obter as mesmas normais
	mix_tables -prefix ${prefix} -input ${intag[${i}]} -nTables 1 -output TMP${i} -channel ${channel} -tableSize 20
	#junta as coordenadas das normais num unico campo
	tmp=${prefix}_${channel}_GTMP${i}_TableData.txt
	dat=gab${i}.dat
	rm -f ${dat} 
	for k in `seq 1 ${numlights}` ; do
		gawk -v k=${k} '/^[\#]/{next} (NF >= 4){mag = $4; printf "%s:%s:%s:%02d ", $1, $2, $3,k;  printf " %9.7f\n" , $(4+k)*mag;  }' < ${tmp} >> ${dat}
	done
done
join -j1 1 -j2 1 gab0.dat gab1.dat > gab.dat
outeps="${prefix}_${channel}_G${intag[0]}_G${intag[1]}_plot.eps"

gnuplot <<EOF
	set term postscript EPS color linewidth 2 "TimesRoman" 30
	set output "${outeps}"
	plot "gab.dat" using 2:3 with points
EOF

kghostview ${outeps}