#! /bin/bash 
# Last edited on 2010-05-12 22:51:30 by stolfilocal

usage="${0##*/} {DMIN} {DMAX} {HEIGHT} > {OUTFILE}.pdf"
# All dimensions in millimeters

if [[ $# -ne 3 ]]; then
  echo "usage: ${usage}" 1>&2 ;
  echo "aborted" 1>&2 ;
  exit 1
fi

dmin="$1"; shift;
dmax="$1"; shift;
height="$1"; shift;

tmp="/tmp/$$"

cat > ${tmp}.ps <<EOF
%!PS-Adobe-2.0
%%Creator: plot-unrolled-cone.sh
%%Title: unrolled cone
%%Pages: 1
%%BoundingBox: 0 0 612 792
%%EndComments
%%EndProlog
%%BeginPaperSize: Letter
%%EndPaperSize
%%Page: 1 1

/dmin ${dmin} def      % Diameter of cup base (mm).
/dmax ${dmax} def      % Diameter of cup mouth (mm).
/height ${height} def  % Vertical height of cup (mm).

/rmin dmin 2 div def % Radius of cup base (mm).
/rmax dmax 2 div def % Radius of cup mouth (mm).

/rhole 7.5 def % Radius of hole in base lining (mm).

/dr rmax rmin sub def 
/width dr dr mul height height mul add sqrt def  % Wall lining width (mm).
/ang 360 dr mul width div def % Length of wall lining (degrees).
/rint dmin 2 div width mul dr div def % Inner radius of wall lining unrolled (mm).
/rout rint width add def % Outer radius of wall lining unrolled (mm).

72 dup scale
8.0 5.5 translate

1.0 24.5 div dup scale 

0 1 0 setrgbcolor
0.50 setlinewidth

% Wall lining, unrolled
gsave
rout neg 0 translate

/hang ang 2 div def

/xout rout hang cos mul def % X of outer tip.
/yout rout hang sin mul def % Y of outer tip.

/xint rint hang cos mul def % X of inner tip.
/yint rint hang sin mul def % Y of inner tip.

newpath
 xout yout neg moveto
 0 0 rout hang neg hang arc
 xint yint lineto
 0 0 rint hang hang neg arcn
 closepath
 stroke
 
grestore

% Bottom lining
gsave
 
grestore
width rmin add 1.25 mul neg 0 translate

newpath
 0 0 rmin 0 360 arc
 closepath
 stroke

newpath
 0 0 rhole 0 360 arc
 closepath
 stroke

showpage
%%EndPage
%%Trailer
%%EOF
EOF

ps2pdf ${tmp}.ps ${tmp}.pdf

acroread ${tmp}.pdf

cat ${tmp}.pdf

rm -f ${tmp}.ps ${tmp}.pdf
