// Persistence Of Vision raytracer version 3.5 sample file.
//
// -w320 -h240
// -w800 -h600 +a0.3

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"

background { color rgb <1.000, 1.000, 1.000>  }
#declare color_Plate = rgb 0.70*<0.900, 0.950, 1.000> ;
#declare color_Stick =rgb <1.000, 0.500, 0.000> ;
#declare color_Ball = rgb <1.000, 0.800, 0.000> ;
#declare color_Cell = rgb 0.85*<0.900, 0.950, 1.000> ;

#include "boxes.inc"
#declare plotSz = 0.2 ;

#macro plot_slice(sticks,balls,boxes,plate)
  // Returns the union of the {sticks} and the {plate}, properly painted
  union{ 
	object{sticks
		texture{
			pigment {color color_Stick}
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	object{balls
		texture{
			pigment {color color_Ball}
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	object{boxes
		texture{
			pigment {color color_Cell}
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	object{plate
		texture{
			pigment {color color_Plate } 
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	rotate 60*z
  }
#end

#declare sliceDz = 0.0;

union{
  object{ plot_slice(grid_sticks_00,grid_balls_00,grid_cells_00, grid_plate_00) translate plotSz*<+0.0,+0.0,+sliceDz> }
  object{ plot_slice(grid_sticks_01,grid_balls_01,grid_cells_01, grid_plate_01) translate plotSz*<+0.0,+0.0,+sliceDz> }
  object{ plot_slice(grid_sticks_10,grid_balls_10,grid_cells_10, grid_plate_10) translate plotSz*<+0.0,+0.0,-sliceDz> }
  object{ plot_slice(grid_sticks_11,grid_balls_11,grid_cells_11, grid_plate_11) translate plotSz*<+0.0,+0.0,+sliceDz> }
}

#declare camera_disp = 4*<0.7,0.3,0.5>;
#declare camera_radius = 1.2;
#declare camera_focus = <0,0,0> ;
#declare image_rel_width = image_width;
#declare image_rel_height = image_height;

light_source { vrotate(camera_disp, -42*z) + 0.4*vlength(camera_disp)*z color rgb 0.15*<1,1,1> }
light_source { vrotate(camera_disp, -37*z) + 0.4*vlength(camera_disp)*z color rgb 0.20*<1,1,1> }
light_source { vrotate(camera_disp, -33*z) + 0.3*vlength(camera_disp)*z color rgb 0.40*<1,1,1> }
light_source { vrotate(camera_disp, -30*z) + 0.2*vlength(camera_disp)*z color rgb 0.40*<1,1,1> }
light_source { vrotate(camera_disp, -26*z) + 0.5*vlength(camera_disp)*z color rgb 0.20*<1,1,1> }
light_source { vrotate(camera_disp, -21*z) + 0.5*vlength(camera_disp)*z color rgb 0.15*<1,1,1> }


#include "camera.inc"