// Persistence Of Vision raytracer version 3.5 sample file.

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"

light_source { <20000, 50000, 100000> color rgb 0.80*<1,1,1> }
light_source { <-20000, 50000, 100000> color rgb 0.30*<1,1,1> }

// background { color rgb <0.900, 0.950, 1.000>  }
background { color rgb <1.000, 1.000, 1.000>  }

// #declare color_Plate = rgb <1.000, 0.900, 0.800> ;
#declare color_Plate = rgb 0.8*<0.900, 0.950, 1.000> ;
#declare color_Sticks = rgb <0.600, 0.670, 0.600> ;
#declare color_Balls = rgb <1.000, 0.070, 0.0000> ;

#declare plotSz = 1/3 ;
#include "scene.inc"

#declare plate = box{ <minX,minY,-0.01>, <maxX,maxY,0> }

#declare maxSize = (maxX - minX);
#declare maxMag = 1.0;
object{ 
	union{
		object{ plate 
			scale <1,1,0.01*maxSize>
			rotate 60*z 
			texture{
				pigment {color color_Plate} 
				finish  {diffuse 0.8 ambient 0.2}
			}		
		}
		object{ 
		sticks
			//scale <1,1,(plotSz*maxSize)/maxMag>
			rotate 60*z
			texture{
				pigment {color color_Sticks} 
				finish  {diffuse 0.8 ambient 0.2}
			}		
		}
		object{
			bolinhas

			rotate 60*z
			texture{
				pigment {color color_Balls} 
				finish  {diffuse 0.8 ambient 0.2}
			}		
		}
	}
	
}

#declare camera_disp = 3*maxSize*<-0.3,0.4,0.3>;
#declare camera_radius = 0.7*maxSize;
#declare camera_focus = <0,0,0> ;
#declare image_rel_width = image_width;
#declare image_rel_height = image_height;


#include "camera.inc"