// Persistence Of Vision raytracer version 3.5 sample file.

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"

// background { color rgb <0.900, 0.950, 1.000>  }
background { color rgb <1.000, 1.000, 1.000>  }

#declare color_OpaquePlate = rgb 0.8*<0.900, 0.970, 1.000> ;
#declare color_TransparentPlate =  rgb <0.970, 0.970, 0.9700>;
#declare graph_tx_in =
texture{
	pigment {color rgb <0.800, 0.770, 0.400> } 
	finish  {diffuse 0.8 ambient 0.2}
}	
#declare graph_tx_out =
texture{
	pigment {color rgb <0.500, 0.700, 0.500> } 
	finish  {diffuse 0.8 ambient 0.2}
}

#declare skirt_tx_in = 
texture{
	pigment {color rgb <0.950, 0.470, 0.400> } 
	finish  {diffuse 0.8 ambient 0.2}
}	

#declare skirt_tx_out = texture{ skirt_tx_in }

#declare plotSz = 1/3 ;

#include "scene.inc"
#declare maxSize = 0.5*max(maxX - minX, maxY - minY);

#declare opaque_zero_plate = 
box{
	<minX,minY,zeroLevel-0.01*maxSize>, <maxX,maxY,zeroLevel>
	texture{
		pigment {color color_OpaquePlate } 
		finish  {diffuse 0.8 ambient 0.2}
	}
}

#declare transparent_zero_plate = 
box{
	<minX,minY,zeroLevel-0.01*maxSize>, <maxX,maxY,zeroLevel>
	texture{
		pigment {color color_TransparentPlate filter 0.8  } 
		finish  {diffuse 0.8 ambient 0.2}
	}
}

#declare plot = 
object{ 
	union{
		object{ graph}	
		#if (minZ < zeroLevel) 
			object{ transparent_zero_plate }
		#else
			object{skirt}
			object{opaque_zero_plate}
		#end
		
		
	}
	
}


#declare scene =
object {plot scale <1,1,1.8> rotate 150*z}


object{scene}

light_source { <20000, 50000, 100000> color rgb 0.80*<1,1,1> }
light_source { <-20000, 50000, 100000> color rgb 0.30*<1,1,1> }

#declare camera_disp = 20*maxSize*<-0.3,0.4,0.3>;
#declare camera_radius = 1.6*maxSize;
#declare camera_focus = <0,0,(zeroLevel)> ;
#declare image_rel_width = image_width;
#declare image_rel_height = image_height;


#include "camera.inc"