// Persistence Of Vision raytracer version 3.5 sample file.
//
// -w320 -h240
// -w800 -h600 +a0.3

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"

// background { color rgb <0.900, 0.950, 1.000>  }
background { color rgb <1.000, 1.000, 1.000>  }

#include "boxes.inc"
#declare plotSz = 0.2 ;

// #declare color_Plate = rgb <1.000, 0.900, 0.800> ;
#declare color_Plate = rgb 0.8*<0.900, 0.950, 1.000> ;

#declare color_Tick = color_Plate ;
#declare color_Dark = rgb <1.000, 0.500, 0.000> ;
#declare color_Lite = rgb <1.000, 0.800, 0.000> ;

#macro plot_slice(sticks,plate)
  // Returns the union of the {sticks} and the {plate}, properly painted
  union{ 
	object{sticks
		texture{
			pigment {gradient z 
				 pigment_map {
       					[0.001 color  color_Tick]
					[0.001 color  color_Dark]
					[0.499 color  color_Dark]
					[0.499 color  color_Tick]
					[0.501 color  color_Tick]
					[0.501 color  color_Lite]
					[0.999 color  color_Lite]
					[0.999 color  color_Tick]
      				}
				scale <1,1,2> translate <0,0,0.0000001>
			}
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	object{plate
		texture{
			pigment {color color_Plate } 
			finish  {diffuse 0.8 ambient 0.2}
		}
		
	}
	translate <-(grid_size)/2.0,-(grid_size)/2.0, 0>
	scale < 1, 1 ,(plotSz*grid_size)/max_value >
	rotate 60*z
  }
#end

#declare sliceDz = 0.3;

union{
  object{ plot_slice(grid_sticks_00, grid_plate_00) translate plotSz*grid_size*<+0.0,+0.0,+sliceDz> }
  object{ plot_slice(grid_sticks_01, grid_plate_01) translate plotSz*grid_size*<+0.0,+0.0,+sliceDz> }
  object{ plot_slice(grid_sticks_10, grid_plate_10) translate plotSz*grid_size*<+0.2,-0.2,-sliceDz> }
  object{ plot_slice(grid_sticks_11, grid_plate_11) translate plotSz*grid_size*<+0.0,+0.0,+sliceDz> }
}

#declare camera_disp = 3.5*grid_size*<0.5,0.2,0.3>;
#declare camera_radius = 0.7*grid_size;
#declare camera_focus = <0,0,0> ;
#declare image_rel_width = image_width;
#declare image_rel_height = image_height;

light_source { vrotate(camera_disp, -42*z) + 0.4*vlength(camera_disp)*z color rgb 0.15*<1,1,1> }
light_source { vrotate(camera_disp, -37*z) + 0.4*vlength(camera_disp)*z color rgb 0.20*<1,1,1> }
light_source { vrotate(camera_disp, -33*z) + 0.3*vlength(camera_disp)*z color rgb 0.40*<1,1,1> }
light_source { vrotate(camera_disp, -30*z) + 0.2*vlength(camera_disp)*z color rgb 0.40*<1,1,1> }
light_source { vrotate(camera_disp, -26*z) + 0.5*vlength(camera_disp)*z color rgb 0.20*<1,1,1> }
light_source { vrotate(camera_disp, -21*z) + 0.5*vlength(camera_disp)*z color rgb 0.15*<1,1,1> }


#include "camera.inc"