#!/bin/bash
scale1="$1" ; shift
scale2="$1" ; shift
A="$1" ; shift
B="$1" ; shift
output="$1" ; shift

tmp="/tmp/$$"
gawk '/^[ ]*[0-9]/{ printf "%02d %6.4f\n", $1, $5; }' ${scale1} | sort -k 1,1 > ${tmp}.1 
gawk '/^[ ]*[0-9]/{ printf "%02d %6.4f\n", $1, $5; }' ${scale2} | sort -k 1,1 > ${tmp}.2 
join -1 1 -2 1 -o0,1.2,2.2 ${tmp}.1 ${tmp}.2 > ${tmp}.3
gnuplot << EOF
	set term postscript eps color "TimesRoman" 24
	set output "${output}"
	set xrange [0.05:1.05]
	set yrange [0.05:1.05]
	set logscale xy
	set nokey
	plot "${tmp}.3" using 2:3 with points, \
	(${A}*x + ${B}) with lines
EOF