#! /bin/bash

# Executes {compute_normals} in a test directory, and does the 
# post-processing stuff.

dir="$1"; shift

BIN_DIR="${HOME}/Raab/Versoes_${VERSAO_RAAB}/bin"

if [[ ! -d ${dir} ]] ; then
  echo "not a directory: ${dir}" 1>&2
  exit 1
fi

outdir="${dir}/OUT"
prefix="t"

mkdir -p ${outdir}

echo "***************************************************************************"
echo "***************************************************************************"

# echo " " > .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libraab >> .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libimg >> .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/compute_normals >> .temp1
# echo run \
#   -prefix ${outdir}/${prefix} \
#   `cat ${paramfile} | sed -e 's:[#].*$::'` \
#   >> .temp1
# gdb -exec=${BIN_DIR}/compute_normals -x .temp1


for canal in 0 1 2 3 ; do
  if [[ -r ${outdir}/${prefix}_${canal}_normals.fni ]] ; then
    ${BIN_DIR}/compute_heights \
      ${outdir}/${prefix}_${canal} \
      ${outdir}/${prefix} \
      2.0 \
      ${outdir}/${prefix}_${canal}
  fi
done