#! /bin/bash

# Executes {compute_normals} in a test directory, and does the 
# post-processing stuff.

dir="$1"; shift

BIN_DIR="${HOME}/Raab/Versoes_${VERSAO_RAAB}/bin"

paramfile="${dir}/params_gab.txt"

if [[ ! -d ${dir} ]] ; then
  echo "not a directory: ${dir}" 1>&2
  exit 1
fi

if [[ ! -r ${paramfile} ]] ; then
  echo "parameter file not found: ${paramfile}" 1>&2
  exit 1
fi

outdir="${dir}/OUT"
prefix="t"

echo "processing test ${paramfile} ..." 1>&2

mkdir -p ${outdir}

echo "***************************************************************************"
echo ${BIN_DIR}/generate_sig_table \
  -prefix ${outdir}/${prefix} \
  `cat ${paramfile} | sed -e 's:[#].*$::'` 
echo "***************************************************************************"

# echo " " > .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libraab >> .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libimg >> .temp1
# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/compute_normals >> .temp1
# echo run \
#   -prefix ${outdir}/${prefix} \
#   `cat ${paramfile} | sed -e 's:[#].*$::'` \
#   >> .temp1
# gdb -exec=${BIN_DIR}/compute_normals -x .temp1

${BIN_DIR}/generate_sig_table \
  -prefix ${outdir}/${prefix} \
  `cat ${paramfile} | sed -e 's:[#].*$::'`

