#! /bin/bash

# Executes {compute_normals} in a test directory, and does the 
# post-processing stuff.

if [[ $# -lt 3 ]] ; then
	echo "Should specify at least 3 parameters"
	echo "DIR CHANNELS GAUGETAGS"
	exit 1
fi

dir="$1"; shift
channels="$1"; shift
gaugeTags="$1"; shift




BIN_DIR="${HOME}/Raab/Versoes_${VERSAO_RAAB}/bin"

paramfile="${dir}/params_tab.txt"

if [[ ! -d ${dir} ]] ; then
  echo "not a directory: ${dir}" 1>&2
  exit 1
fi

if [[ ! -r ${paramfile} ]] ; then
  echo "parameter file not found: ${paramfile}" 1>&2
  exit 1
fi




outdir="${dir}/OUT"
prefix="t"

leng=`expr length ${gaugeTags}`

for g in `seq 1 ${leng}` ; do
	gind=$((${g} -1 ))
	gaugeTag=${gaugeTags:${gind}:1}
	for c in R G B ; do
		test_channel=`expr index ${channels} ${c}`
		if [[ ${test_channel} != 0 ]] ; then
			echo "processing test ${paramfile} ..." 1>&2
			
			mkdir -p ${outdir}
			
			echo "***************************************************************************"
			echo ${BIN_DIR}/compute_normals_from_table \
			-prefix ${outdir}/${prefix} \
			-channel ${c} \
			-gaugeTag ${gaugeTag} \
			`cat ${paramfile} | sed -e 's:[#].*$::'` 
			echo "***************************************************************************"
			
			# echo " " > .temp1
			# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libraab >> .temp1
			# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/libimg >> .temp1
			# echo dir ${HOME}/Raab/Versoes_${VERSAO_RAAB}/compute_normals >> .temp1
			# echo run \
			#   -prefix ${outdir}/${prefix} \
			#   `cat ${paramfile} | sed -e 's:[#].*$::'` \
			#   >> .temp1
			# gdb -exec=${BIN_DIR}/compute_normals -x .temp1
			
			actual_channel=`expr index "RGB" ${c}`
			actual_channel=$((${actual_channel} - 1 ))
			
			${BIN_DIR}/compute_normals_from_table \
			-prefix ${outdir}/${prefix} \
			-channel ${c} \
			-gaugeTag ${gaugeTag} \
			`cat ${paramfile} | sed -e 's:[#].*$::'`
			
			${BIN_DIR}/normal_map_to_pnm \
				${outdir}/${prefix}_${actual_channel}_G${gaugeTag}_normals.fni \
				${outdir}/${prefix}_${actual_channel}_G${gaugeTag}_normals.ppm
			
# 			for canal in 0 1 2 3 ; do
# 				if [[ -r ${outdir}/${prefix}_${canal}_G${gaugeTag}_normals.fni ]] ; then
# 					${BIN_DIR}/normal_map_to_pnm \
# 					${outdir}/${prefix}_${canal}_G${gaugeTag}_normals.fni \
# 					${outdir}/${prefix}_${canal}_G${gaugeTag}_normals.ppm
# 				fi
# 			done
# 			
# 			for f in \
# 			{0,1,2,3}_normals.ppm \
# 			gauge_mask.ppm \
# 			weights.pgm \
# 			L_{??}.ppm \
# 			K_{??}.ppm \
# 			albedo.ppm ; \
# 			do
# 				if [[ -r ${outdir}/${prefix}_${f} ]] ; then
# 					convert ${outdir}/${prefix}_${f} \
# 					${outdir}/${prefix}_${f%%.*}.png
# 				fi
# 			done
		fi
	done
done	
# display -filter box -resize '200%' ${outdir}/${prefix}_*.png
