#pragma once

#include <memory>
#include <stdexcept>
#include <opencv2/core/core.hpp>
#include <cairo/cairo.h>

#include <cdt2d/polygon2d.hpp>

namespace cdt{

using cairo_surface_ptr = std::unique_ptr<
	cairo_surface_t,
	decltype(&cairo_surface_destroy)
>;

using cairo_context_ptr = std::unique_ptr<
	cairo_t,
	decltype(&cairo_destroy)
>;

/**
  * Draw the surface `surface` in the image `dst`
  */
void surface_to_mat(cairo_surface_t* surface, cv::Mat& dst);

/**
  * Draw the `polygon` to the cairo context `cr`
  */
void draw(cairo_t* cr, polygon2d const& polygon);

}
