#include <cdt2d/ruler.hpp>

namespace ruler{

namespace literals{

nanometer operator"" _nm(unsigned long long n)
{
	return nanometer{n};
}

millimeter operator"" _mm(unsigned long long n)
{
	return millimeter{n};
}

centimeter operator"" _cm(unsigned long long n)
{
	return centimeter{n};
}

meter operator"" _m(unsigned long long n)
{
	return meter{n};
}

kilometer operator"" _km(unsigned long long n)
{
	return kilometer{n};
}

ppm operator"" _ppm(unsigned long long n)
{
	return ppm{n};
}

ppcm operator"" _ppcm(unsigned long long n)
{
	return ppcm{n};
}

ppmm operator"" _ppmm(unsigned long long n)
{
	return ppmm{n};
}

ppm operator"" _ppm(long double n)
{
	return ppm{n};
}

ppcm operator"" _ppcm(long double n)
{
	return ppcm{n};
}

ppmm operator"" _ppmm(long double n)
{
	return ppmm{n};
}

} // end of namespace literals
} // end of namespace ruler

/*
 * stream operators
 * ----------------
 */

std::ostream& operator<<(std::ostream& out, ruler::ppm const& ppm)
{
	out << ppm.count() << "ppm";
	return out;
}

std::ostream& operator<<(std::ostream& out, ruler::ppcm const& ppcm)
{
	out << ppcm.count() << "ppcm";
	return out;
}

std::ostream& operator<<(std::ostream& out, ruler::ppmm const& ppmm)
{
	out << ppmm.count() << "ppmm";
	return out;
}

