#include <iostream>

#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>

#include <cdt2d/iterator.hpp>

/*
 * check if the pixels are correct and test the adaptor for cv::Mat const
 */
bool check(cv::Mat const& img)
{
	auto max_norm = cv::norm(cv::Point2i{img.cols, img.rows});

	auto count = 0;
	for(auto [ pixel, point ] : cdt::pixels_at<uchar>(img)){
		auto normalized_norm = cv::norm(point)/max_norm;
		auto v = static_cast<uchar>(normalized_norm*255);
		if(pixel != v)
			return false;
		count++;
	}

	if(count != img.rows*img.cols)
		return false;

	return true;
}

int main()
{

	cv::Mat img(500, 500, CV_8UC1);

	auto max_norm = cv::norm(cv::Point2i{img.cols, img.rows});

	for(auto [ pixel, point ] : cdt::pixels_at<uchar>(img)){
		auto normalized_norm = cv::norm(point)/max_norm;
		pixel = static_cast<uchar>(normalized_norm*255);
	}

	if(check(img) == false)
		return EXIT_FAILURE;

	cv::imwrite("00-pixel-point-adaptor.png", img);

	return EXIT_SUCCESS;
}
