// Cmeras e luzes padronizadas
// Last edited on 2013-02-01 19:08:24 by stolfilocal

#macro camlight(ctr,rad,cav,dst,upp,lux,lnr,lar,shd)
  // {ctr} = center of interest in scene.
  // {rad} = approx radius of scene.
  // {cav} = vector pointing from {ctr} to camera; only its direction matters.
  // {dst} = the distance from camera to {ctr}.
  // {upp} = the scene's vertical axis ({sky} parameter), usually {z} or {y}.
  // {lux} = a scaling factor for the intensity of standard light sources.
  // {lnr} = number of rings in light cluster.
  // {lar} = angular radius of light cluster (degrees).
  // {shd} = true if lights cast shadows.
  #local dir = vnormalize(cav);
  #local len = (dst);
  #local swh = sqrt(image_width/image_height);
  #local ape = 1.41*(rad)/(len);  // Camera aperture.
  camera {
    location (ctr) + len*dir
    right  -swh*ape*x
    up     1.0/swh*ape*y
    sky    (upp)
    look_at (ctr)
  }
  #if (lux > 0)
    #local hor = vnormalize(vcross(upp,dir)); // Camera's horizontal direction.
    #local ver = vnormalize(vcross(dir,hor)); // Camera's vertical direction.
    #local sol_cam = vnormalize(< 2, 3, 4 >);     // Light direction in camera system.
    #local sol = sol_cam.x*hor + sol_cam.y*ver + sol_cam.z*dir; // Light direction.
    #local sol_xyrd = sqrt(sol.x*sol.x + sol.y*sol.y);
    #local sol_elev = degrees(atan2(sol.z,sol_xyrd));
    #if (sol_xyrd = 0) #local sol_azim = 0; #else #local sol_azim = degrees(atan2(sol.y,sol.x)); #end
    object{ lamp_array(lnr,lar,lux,shd)
      rotate 360*(sqrt(5)-1)/2*x
      scale 10*len
      rotate -sol_elev*y 
      rotate sol_azim*z
      translate ctr 
    }
  #end
#end
