// Last edited on 2013-01-22 02:01:25 by stolfilocal

// Defines instance 01 of the macro {field}

#include "field.inc"
#include "field_TSC.inc"

#declare fvp_VX = -pi/2;
#declare fvp_VY = 2*pi/3;
#declare fvp_W = 5*pi/3;
#declare fvp_D = 4*pi/3;
#declare fvp_S = 7*pi/4;
#declare fvp_Q = 1/2;

#declare field_max = field_TSC_max(fvp_VX,fvp_VY,fvp_W,fvp_D,fvp_S,fvp_Q);

#macro field(xp,yp,zp,tt,  term)
  // A version of {field_TSC} with specific parameters,
  // rotated a little.
  
  // Rotate domain about the origin:
  #local ang = pi/7; // Rotation angle
  #local xr = xp*cos(ang) + yp*sin(ang);
  #local yr = yp*cos(ang) - xp*sin(ang);
  
  #local uu = field_TSC_term(fvp_VX,fvp_VY,fvp_W,fvp_D,fvp_S,fvp_Q, term, xr,yr);
  
  // Un-rotate velocity:
  #local xv = uu.x*cos(ang) - uu.y*sin(ang);
  #local yv = uu.y*cos(ang) + uu.x*sin(ang);
  #local vp = < xv, yv, uu.z >;
  
  vp
#end
