// Last edited on 2013-02-02 21:10:36 by stolfilocal

// Defines instance 02 of the macro {field}

#include "field.inc"
#include "field_LIN.inc"

#declare f02_C = array[3];
#declare f02_C[0] = +0.1;
#declare f02_C[1] = +0.2;
#declare f02_C[2] = -0.3;

#declare f02_J = array[3][3]
#declare f02_J[0][0] = +0.5;
#declare f02_J[0][1] = 00.0;
#declare f02_J[0][2] = 00.0;

#declare f02_J[1][0] = 00.0;
#declare f02_J[1][1] = +0.2;
#declare f02_J[1][2] = 00.0;

#declare f02_J[2][0] = 00.0;
#declare f02_J[2][1] = 00.0;
#declare f02_J[2][2] = -0.3;

#macro field_max(term) 
  #local vmax = field_LIN_max(f02_C,f02_J, term);
  vmax
#end

#macro field(xp,yp,zp,tt,  term)
  // A version of {field_LIN} with specific parameters,
  // rotated a little.
  
  // Rotate domain about the origin:
  #local ang1 = 30;
  #local ang2 = 27;
  #local ang3 = 12;
  #local q = <xp,yp,zp>;
  #local q = vaxis_rotate(q, z, ang1);
  #local q = vaxis_rotate(q, y, ang2);
  #local q = vaxis_rotate(q, x, ang3);
  
  #local uu = field_LIN_term(f02_C,f02_J, term, q.x,q.y,q.z);
  
  // Un-rotate field:
  
  #local uu = vaxis_rotate(uu, x, -ang3);
  #local uu = vaxis_rotate(uu, y, -ang2);
  #local uu = vaxis_rotate(uu, z, -ang1);
  
  uu
#end
