// Last edited on 2013-02-02 21:30:39 by stolfilocal
// General parameters for all subfigs and flows.

#include "translucent_layer_texture.inc"

// ----------------------------------------------------------------------
// GRID OF PARTICLES
#declare rgb_grid = < 0.200, 0.700, 1.000 >;

// Grid particles:
#declare rgb_grid_particle = 0.800 * rgb_grid;
#declare tx_grid_particle = 
  texture{
    pigment{ color rgb rgb_grid_particle }
    finish{ diffuse 1.0 ambient 0.0 specular 0 }
  }

// Arrows on sample grid particles:
#declare rgb_grid_arrow = 0.900 * rgb_grid;
#declare tx_grid_arrow = 
  texture{
    pigment{ color rgb rgb_grid_arrow }
    finish{ diffuse 0.3 ambient 0.7 specular 0 }
  }

// ----------------------------------------------------------------------
// ORIGIN/REFERENCE PARTICLE

#declare rgb_origin = < 1.000, 0.000, 0.200 >;

// Reference particle:
#declare rgb_origin_particle = 0.600 * rgb_origin;
#declare tx_origin_particle = 
  texture{
    pigment{ color rgb rgb_origin_particle }
    finish{ diffuse 1.0 ambient 0.0 specular 0 }
  }

// Arrow on reference particle:
#declare rgb_origin_arrow = 0.700 * rgb_origin;
#declare tx_origin_arrow = 
  texture{
    pigment{ color rgb rgb_origin_arrow }
    finish{ diffuse 0.3 ambient 0.7 specular 0 }
  }

// ----------------------------------------------------------------------
// RING OF PARTICLES

// Flow sampling ring:
#declare rgb_ring_circle = < 0.300, 0.400, 0.500 >;
#declare tx_ring_circle = 
  texture{
    pigment{ color rgb rgb_ring_circle }
    finish{ diffuse 0.3 ambient 0.7 specular 0 }
  }

// Particles on ring:
#declare rgb_ring_particle = < 1.000, 0.200, 0.300 >;
#declare tx_ring_particle = 
  texture{
    pigment{ color rgb rgb_ring_particle }
    finish{ diffuse 1.0 ambient 0.0 specular 0 }
  }

// Arrows on ring particles:
#declare rgb_ring_arrow = 0.750*rgb_ring_particle;
#declare tx_ring_arrow = 
  texture{
    pigment{ color rgb rgb_ring_arrow }
    finish{ diffuse 0.3 ambient 0.7 specular 0 }
  }

// ----------------------------------------------------------------------
// PATHLINES

// Pathlines:
#declare rgb_pathline = < 0.200, 0.450, 0.600 >;
#declare tx_pathline = 
  texture{
    pigment{ color rgb rgb_pathline }
    finish{ diffuse 0.3 ambient 0.7 specular 0 }
  }

// ----------------------------------------------------------------------
// MATERIAL PARTICLES
#declare rgb_stress_particle_defn = translucent_layer_color(0.3); // 0.6300
#declare abs_stress_particle_defn = rgb_stress_particle_defn;
#declare tx_stress_particle_defn = translucent_layer_texture(rgb_stress_particle_defn,0.40,0.10,0.95)

#declare rgb_stress_particle_ball = < 0.500, 0.680, 0.700 >; // 0.6300
#declare abs_stress_particle_ball = rgb_stress_particle_ball;
#declare tx_stress_particle_ball = translucent_layer_texture(rgb_stress_particle_ball,1.00,0.20,0.00)

// ----------------------------------------------------------------------
// SURFACE ELEMENTS
#declare rgb_stress_surfel = < 0.900, 0.980, 0.200 >; // 0.8075
#declare tx_stress_surfel = 
  texture{
    pigment{ color rgb rgb_stress_surfel}
    finish{ diffuse 0.3 ambient 0.7 specular 0 }
  }

// ----------------------------------------------------------------------
// NORMAL ARROWS ON SURFACE ELEMENTS
#declare rgb_stress_normal_vec = < 0.750, 0.750, 0.750 >;
#declare tx_stress_normal_vec = 
  texture{
    pigment{ color rgb rgb_stress_normal_vec }
    finish{ diffuse 0.3 ambient 0.7 specular 0 }
  }

// ----------------------------------------------------------------------
// TOTAL FORCE ARROWS ON SURFACE ELEMENTS
#declare rgb_stress_force_def = < 0.700, 0.100, 0.500 >; // 0.3180
#declare tx_stress_force_def = 
  texture{
    pigment{ color rgb rgb_stress_force_def }
    finish{ diffuse 0.7 ambient 0.3 specular 0 }
  }

// ----------------------------------------------------------------------
// STRESS ARROWS ON SURFACE ELEMENTS
// Outward stress arrows on surface elements:
#declare rgb_stress_vector_out = < 0.850, 0.320, 0.000 >; // 0.4385
#declare tx_stress_vector_out = 
  texture{
    pigment{ color rgb rgb_stress_vector_out }
    finish{ diffuse 0.7 ambient 0.3 specular 0 }
  }

// Inward stress arrows on surface elements:
#declare rgb_stress_vector_in = < 0.000, 0.530, 0.850 >; // 0.4115
#declare tx_stress_vector_in = 
  texture{
    pigment{ color rgb rgb_stress_vector_in }
    finish{ diffuse 0.7 ambient 0.3 specular 0 }
  }
