// Last edited on 2013-01-22 02:00:00 by stolfilocal

#include "arrow.inc"

#macro particle_with_arrow(pp,vp, vmag,Ra, frp,txp, fsa,fra,txa)
  // Generates a particle with an arrow.
  
  // {pp}  Position of particle.
  // {vp}  velocity of particle.
  
  // {vmag} Max velocity magnitude to assume for scaling arrow lengths.
  // {Ra}   Max desirable arrow length for scaling arrow lengths.

  // The length of the arrow will be the modulus of {vp} divided by {vmag}
  // and multiplied by {fsa*Ra}. Thus if {fsa} is 1 and the 
  // velocity has magnitude {vmag}, the arrow's length will be {Ra}.

  // The radius of the arrow shaft and of the sampling ball is set
  // to some fixed fraction of {Ra}, but multiplied by {fra} 
  // and {frp}. respectively.  They should look about OK with
  // {fra=1} and {frp=1}
  
  // The arrow proper will be painted with texture {txa}.
  // The sample point will be painted with texture {txp}
  
  #local va = fsa*vp*Ra/vmag;
  
  #local rp = frp*0.070*Ra;  // Particle radius.
  
  #local ra = fra*0.035*Ra;  // Arrow shaft radius.
  #local sh =  8.0*ra;       // Arrowhead length.
  #local rh =  3.0*ra;       // Arrowhead radius.
  #local rt =  0.5*ra;       // Arrrowhead fattening radius.
  
  #local parr = 
    union{
      #if (vlength(va) > 0.001*ra)
        object{ arrow(va,ra, sh,rh,rt) texture{ txa } }
      #end
      sphere{ 0, rp texture{ txp } }
      translate pp
    }
  
  parr

#end
