// Last edited on 2013-01-21 00:21:41 by stolfilocal

// The client must predefine the {field} macro.
// Defines macro {sampler_grid} that generates an image of 
// a term of the flow defined by the macro {field}.

#include "particle_with_arrow.inc"

#macro sampler_grid_circ(zp,tt, term,  Rg,Rclip, vmag,Ra, dp, frp,txp, fro, fsa,fra,txa)
  // Generates a scene consisting of a grid of particles with
  // arrows showing the direction and magnitude of the specified {term} of velocity field {field}at time {tt}.
  
  // {zp}    Z of plane to be sampled.
  // {tt}    Time to be sampled.
  // {term}  Selects the term of Taylor's expansion that will be shown.

  // {Rg}    Grid radius. The particle grid will cover {-Rg} to {+Rg} in {X} and {Y}.
  // {Rclip} If positive, clips the grid to a disk of radius {round}.
  
  // {vmag}  Max velocity magnitude to assume for scaling arrow lengths.
  // {Ra}    Max desirable arrow length for scaling arrow lengths.

  // {dp}    The particle spacing.

  // {frp}   Extra factor for particle radius. Normally 1. 
  // {txp}   Texture for particles.

  // {fro}   Extra factor for particle and arrow radius at origin. Normally 1 or 0. 
  
  // {fsa}   Extra factor for arrows lengths. Normally 1. 
  // {fra}   Extra factor for arrows shaft radius. Normally 1. 
  // {txa}   Texture for velocity arrows.

  // There will be a particle at the origin iff {np} is odd and {fro > 0}.
  
  // The parameters {fsa,fra,frp} are extra scale factors
  // for the length and radius of arrow shafts and the radius of particles.
  // The parameter {fro} is an extra factor
  // for the radius of the ball and radius of the particle at origin (if any).
  // If these parameters are set to 1, a velocity vector with length {vmag} 
  // is mapped to an arrow whose length is half the particle spacing; and the 
  // arrow and ball radii should be appropriate.
  
  #local Rmax = Rclip - 0.25*Ra; // Actual clipping radius, to avoid particles running into ring.
  
  union{

    #local rad = 0;
    #local mp = 1;  
    #local phase = 0;  // Angle of first partice in ring; irrelevant for origin.
    #while (rad < Rmax)
      // Draw a ring of {mp} particles at radius {rad} starting with the given phase
      #local astep = 2*pi/mp; // Angular step; irrelavant for origin.

      #local it = 0;
      #while (it < mp)
        // Draw particle {it} of this ring:
        #if (rad = 0)
          #if (fro > 0)
            #local pp =  < 0, 0, zp >;
            #local vp = field(pp.x,pp.y,pp.z,tt, term);
            object{ particle_with_arrow(pp,vp, vmag,Ra, fro*frp,txp, fsa,fro*fra,txa) }
          #end
        #else
          #local ang = it*astep + phase;
          #local xp = rad*cos(ang);
          #local yp = rad*sin(ang);
          // !!! Consider adding some jitter here.
          #local pp = < xp, yp, zp >;
          #local vp = field(pp.x,pp.y,pp.z,tt, term);
          object{ particle_with_arrow(pp,vp, vmag,Ra, frp,txp, fsa,fra,txa) }
        #end
        #local it = it + 1;
      #end
      
      // Compute {mp,phase} for the next ring:
      // {mp} must be a multiple of 6.
      

      #else
        #local 
    
      #local mx = 0.5*mod(iy,2); // Relative row shift.
        // Compute coord of point in {[-Rg _ +Rg]^2}: 
        #if ((Rclip = 0) | ((xp*xp + yp*yp) < Rmax*Rmax))

          
          #if ((ix != 0) | (iy != 0))
        #end

        #local ix = ix + 1;
      #end
      
      #local iy = iy + 1;
    #end

  }
#end
