// Last edited on 2013-01-20 00:58:23 by stolfilocal

// Defines macro {sampler_ring}; requires macro {field_vel}.

#include "particle_with_arrow.inc"

#macro sampler_ring(zp,tt, term, Rf,Rc, vmag,Ra, np, frc,txc, frp,txp, fsa,fra,txa)
  // Generates a scene consisting of a ring of sampling points with
  // arrows showing the direction and magnitude of the specified {term} of velocity field {field}
  // on the {Z=zp} plane at time {tt}.  The camera is positioned to enclose
  // the square from {-Rf} to {+Rf} in {X} and {Y}.

  // {zp}   Z of plane to be sampled.
  // {tt}   Time to be sampled.
  // {term} Selects the term of Taylor's expansion that will be shown.

  // {Rf}   Grid radius. The samples will spans from {-Rf} to {+Rf} in {X} and {Y}.
  // {Rc}   Major radius of ring.

  // {vmag} Max velocity magnitude to assume for scaling arrow lengths.
  // {Ra}   Max desirable arrow length for scaling arrow lengths.
  
  // {np}   Number of particles in ring.

  // {frc}  Extra factor for minor radius of ring. Normally 1. 
  // {txc}  Texture for ring.

  // {frp}  Extra factor for particle radius. Normally 1. 
  // {txp}  Texture for particles.

  // {fsa}  Extra factor for arrows lengths. Normally 1. 
  // {fra}  Extra factor for arrows shaft radius. Normally 1. 
  // {txa}  Texture for velocity arrows.
  
  // The parameters {frc,fsa,fra,frp} are extra scale factors
  // for the minor radius of the sampling circle, the length and radius of arrow shafts,
  // and the radius of particles. If these parameters are set to 1, a velocity vector with length {vmag} 
  // is mapped to an arrow whose length is equal to the sampling circle radius; and the 
  // arrow and ball radii should be appropriate.
  
  #local rc = frc*0.0040*Rc;  // Minor radius of particle circle.
  
  #local dt = 360/np;
  
  union{
    
    torus{ Rc,rc rotate 90*x texture{ txc } }

    #local tshift = 1/3;
    #local i = 0;
    #while (i < np) 
      #local tp = (i + tshift)*dt;     // Angle of particle rel origin (degrees).
      #local pp = vrotate(< Rc, 0, zp >, tp*z);  // Coords of particle.
      #local vp = field(pp.x,pp.y,pp.x,tt, term);
            
      object{ particle_with_arrow(pp,vp, vmag,Ra, frp,txp, fsa,fra,txa) }
      
      #local i = i + 1;
    #end
  }

#end
