// Dodecahedron normals
// Last edited on 2013-02-01 22:04:38 by stolfilocal

#macro set_normals_dodecahedron(uu, tu, tx, k)
  // Fills the array {uu[k..k+11]} with the vertices of a regular dodecahedron.
  // Also sets {tu[k..k+11]} to {tx}
  // Returns the next free index.
  
  // Vertices of dodecahedron are {(±fa, ±fb, 0)/mab} rotated to the right:
  #local fa = 1.0;
  #local fb = (sqrt(5) - 1)/2;
  #local mab = sqrt(fa*fa + fb*fb);
  
  #local iu = -1;
  #while (iu <= +1) 
    #local iv = -1;
    #while (iv <= +1)
      #declare uu[k] = < iu*fa, iv*fb, 0 >/mab; #declare tu[k] = tx; #local k = k + 1;
      #declare uu[k] = < 0, iu*fa, iv*fb >/mab; #declare tu[k] = tx; #local k = k + 1;
      #declare uu[k] = < iv*fb, 0, iu*fa >/mab; #declare tu[k] = tx; #local k = k + 1;
      #local iv= iv + 2;
    #end
    #local iu = iu + 2;
  #end
  (k)
#end
