// Icosahedron normals
// Last edited on 2013-02-01 22:15:26 by stolfilocal

#macro set_normals_icosahedron(uu, tu, tx, k)
  // Fills the array {uu[k..k+19]} with the vertices of a regular icosahedron.
  // Also sets {tu[k..k+19]} to {tx}
  // Returns the next free index.
  
  // Vertices of dodecahedron are {(±fa, ±fb, 0)/mab} rotated to the right:
  #local fa = 1.0;
  #local fb = (sqrt(5) - 1)/2;
  #local mab = sqrt(fa*fa + fb*fb);
  
  // Vertices of icosahedron are {(±fc, 0, ±fd)/mcd} rotated to the right, and {(±fe, ±fe, ±fe)}:
  #local fc = (2*fa+fb);
  #local fd = fa;
  #local mcd = sqrt(fc*fc + fd*fd);

  #local fe = (fa+fb);
  #local me = fe*sqrt(3);

  #local iu = -1;
  #while (iu <= +1) 
    #local iv = -1;
    #while (iv <= +1)
      #declare uu[k] = < iu*fc, 0, iv*fd >/mcd; #declare tu[k] = tx; #local k = k + 1;
      #declare uu[k] = < iv*fd, iu*fc, 0 >/mcd; #declare tu[k] = tx; #local k = k + 1;
      #declare uu[k] = < 0, iv*fd, iu*fc >/mcd; #declare tu[k] = tx; #local k = k + 1;
      #local iw = -1;
      #while (iw <= +1)
        #declare uu[k] = < iu*fe, iv*fe, iw*fe >/me; #declare tu[k] = tx; #local k = k + 1;
        #local iw = iw + 2;
      #end
      #local iv = iv + 2;
    #end
    #local iu = iu + 2;
  #end
  (k)
#end
