// Octahedron normals
// Last edited on 2013-02-01 22:05:55 by stolfilocal

#macro set_normals_octahedron(uu, tu, tx, k)
  // Fills the array {uu[k..k+7]} with the vertices of a regular octahedron.
  // Also sets {tu[k..k+7]} to {tx}
  // Returns the next free index.
  #declare uu[k+0] = < +1, +1, +1 >; #declare tu[k+0] = tx; 
  #declare uu[k+1] = < +1, +1, -1 >; #declare tu[k+1] = tx; 
  #declare uu[k+2] = < +1, -1, +1 >; #declare tu[k+2] = tx; 
  #declare uu[k+3] = < +1, -1, -1 >; #declare tu[k+3] = tx; 
  #declare uu[k+4] = < -1, +1, +1 >; #declare tu[k+4] = tx; 
  #declare uu[k+5] = < -1, +1, -1 >; #declare tu[k+5] = tx; 
  #declare uu[k+6] = < -1, -1, +1 >; #declare tu[k+6] = tx; 
  #declare uu[k+7] = < -1, -1, -1 >; #declare tu[k+7] = tx; 
  (k + 8)
#end
