// Last edited on 2013-02-02 13:20:35 by stolfilocal

#macro show_normals(RP, uu, tu, nu)
  // Shows a set of normal directions.
  // {RP}          Radius of particle.
  // {uu[0..nu-1]} Normals.
  // {tu[0..nu-1]} Textures.
  // {nu}          Number of normals.

  // Surface elements with forces, and their punchers:
  #local txb = 
    texture{ 
      pigment{ color rgb < 1.000, 0.950, 0.900 > }
      finish{ diffuse 0.3 ambient 0.7 }
    }
  #local rp = 0.02*RP; // Radius of dots.
  #local balls = 
    union{
      sphere{ 0,RP texture{ txb } }
      #local k = 0;
      #while (k < nu)
        #local ct = RP*uu[k];
        sphere{ ct, rp texture{ tu[k] } }
        #local k = k + 1;
      #end
    }
  object{ balls }
#end

