// Last edited on 2013-02-02 21:30:02 by stolfilocal
// Two-particle system to illustrate definition of stress.

#include "general_parameters.inc"
#include "stress_parts.inc"

#macro stress_definition(RP,srad,LA,mra,nrng, vf,vs)
  // Two particles separated by a surface patch, showing its force abd stress arrows.
  // {RP}     Radius of each particle.
  // {srad}   Angular radius of patch (radians).
  // {LA}     Max arrow length for scaling.
  // {mra}    Arrow thinning factor (1.0 = normal).
  // {nrng}   Num of arrow rings (if 0 plots only central force).
  // {vf}     The force vector to show.
  // {vf}     The stress vectors to show.
  
  // Particle parameters:
  #local RF = 0; // Radius of fog ball.
  #local un = z;
  #local vn = y;
  #local txp0 = texture{ tx_stress_particle_defn }
  #local txp1 = texture{ tx_stress_particle_defn }
  #local ctr1 = 2*cos(srad)*RP*un;
  #local uct = -1.5*RP; // Cut position in direction {un}.
  #local vct = 1.25*RP;            // Cut position in direction {vn}.

  // Surface element parameters:
  #local txd = texture{ tx_stress_surfel }

  // Stress arrow parameters:
  #local vmax = field_max(6);
  #local rar = mra*0.015*RP; // Typical radius of arrow shafts.
  #local rar_f = 1.0*rar; // Shaft radius for total force arrow.
  #local rar_s = 0.5*rar; // Shaft radius for stress arrows.
  #local txd = texture{ tx_stress_surfel }
  #local txf = texture{ tx_stress_force_def }
  #local txs = texture{ tx_stress_vector_out }

  #local stb_particles = 
    intersection{
      union{
        difference{ 
          object{ stress_particle(RP,RF, txp0) }
          object{ stress_surfel_puncher(+un, RP,srad, txp0) }
        }
        difference{ 
          intersection{
            object{ stress_particle(RP,RF, txp1) }
            object{ stress_particle_cutter(RP,un,uct,vn,vct, txp1) }
          }
          object{ stress_surfel_puncher(-un, RP,srad, txp1) }
          translate ctr1  
        }
      }
   }

  #local stb_surfel = 
    object{ stress_surfel(un, RP,srad, txd) }

  #local stb_vectors = 
    union{
      object{ stress_vectors(un,vn,vf, RP,srad,LA,vmax,rar_f,0,   txf,txf) }
      object{ stress_vectors(un,vn,vs, RP,srad,LA,vmax,rar_s,nrng, txs,txs) }
    }

  #local scene = 
    union{
      object{ stb_particles }
      object{ stb_surfel }
      object{ stb_vectors }
    }
    
  object{ scene }
#end

