// Last edited on 2013-02-02 21:19:21 by stolfilocal

#include "general_parameters.inc"
#include "stress_parts.inc"

#macro stress_spiny_ball(tt, RP,RF,srad,LA,mra,LN, un, nu)
  // A particle with various surface elements and their stress arrows:
  // {RP}          Radius of particle.
  // {srad}        Angular radius of patch (radians).
  // {LA}          Max arrow length for scaling.
  // {mra}         Arrow thinning factor (1.0 = normal).
  // {LN}          Length of normal vectors (0 to omit them).
  // {un[0..nu-1]} Patch normals.
  // {nu}          Number of normals.

  #debug "ENTER stress_ball\n"

  // Particle parameters:
  #local txp = texture{ tx_stress_particle_ball }

  // Arrow parameters:
  #local vmax = RP*cos(srad)*field_max(6);
  #local rar = mra*0.0075*RP; // Typical radius of arrow shafts.
  #local rar_s = 1.00*rar; // Shaft radius for stress arrows.
  #local rar_n = 0.50*rar; // Shaft radius for normal arrows.
  #local txd = texture{ tx_stress_surfel }
  #local txn = texture{ tx_stress_normal_vec }
  #local txf = texture{ tx_stress_vector_out }
  #local txg = texture{ tx_stress_vector_in }

  #local stb_punchers = 
    union{
      #local k = 0;
      #while (k < nu)
        #local unk = vnormalize(un[k]);
        object{ stress_surfel_puncher(unk, RP,srad, txp) }
        #local k = k + 1;
      #end
    }

  #local stb_particle = 
    object{ stress_particle(RP,RF, txp) }

  #debug "  building stb_disks_and_stresses\n"
  #local stb_disks_and_stresses = 
    union{
      #local k = 0;
      #while (k < nu)
        #local unk = vnormalize(un[k]);
        #local vnk = vnormalize(x - vdot(x,unk)*unk);  // A vector perpendicular to {unk}.
        #local vstress = field(unk.x,unk.y,unk.z, tt, term);
        object{ stress_surfel(unk, RP,srad, txd) }
        object{ stress_vectors(unk,vnk, vstress, RP,srad,LA,vmax,rar_s,0, txf,txg) }
        #if (LN > 0)
          object{ stress_vectors(unk,vnk, unk, RP,srad,LN,1.0,rar_n,0, txn,txn) }
        #end
        #local k = k + 1;
      #end
    }
    
  #debug "  building scene\n"
  #local scene = 
    union{
      difference{ 
        object{ stb_particle }
        object{ stb_punchers }
      }
      object{ stb_disks_and_stresses }
    }
    
  object{ scene }
  #debug "EXIT stress_ball\n"
#end
