// Last edited on 2013-02-01 18:57:13 by stolfilocal
// Arrow field showing velocity vector.

#include "general_parameters.inc"
#include "sampler_grid.inc"

#macro subfig(tt)
  // General parameters
  #local zp = 0;
  #local tt = 0;
  #local Rc = 0.37;                        // Radius of disk of interest.
  #local Rv = (term = 0 ? 2*Rc : 1.05*Rc); // Radius of largest circle that should be entirely visible.
  #local vmag = field_max;              // Nominal max velocity for scaling.
  #local Ra = Rv/6;                        // Desirable max arrow length (also determines the grid spacing).

  #local txo = texture{ tx_origin_particle }  // Texture for particle at origin.
  #local fsa = 1.5;                           // Extra length factor for arrows.

  // Particle grid with velocity arrows:
  #local R_g = 1.2*Rv;                        // Half-width and half-height of sampled area.
  #local Rclip_g = (term = 0 ? 0 : Rc);       // Round clipping radius for particle grid and fuzz.
  #local dp_g = 0.75*Ra;                      // Spacing of particles in sampling grid.
  #local mj_g = 0.15*dp_g;                    // Magnitude of particle position jitter.
  #local fra_g = 0.8;                         // Extra radius factor for grid arrows.
  #local frp_g = 0.8;                         // Extra radius factor for grid particles.
  #local txp_g = texture{ tx_grid_particle }  // Texture for grid particle.
  #local txa_g = texture{ tx_grid_arrow }     // Texture for grid arrows.

  #local scene_grid = 
    object{ sampler_grid(zp,tt, term, R_g,Rclip_g, vmag,Ra, dp_g,mj_g, frp_g,txp_g, 0, fsa,fra_g,txa_g) }

  // Particle at origin:
  #local fra_o = 1.2;                           // Extra radius factor for origin arrow.
  #local frp_o = 1.6;                           // Extra radius factor for origin particle.
  #local txp_o = texture{ tx_origin_particle }  // Texture for origin particle.
  #local txa_o = texture{ tx_origin_arrow }     // Texture for ring arrows.

  #local po = < 0, 0, zp >; // Reference particle at origin.
  #local vo = field(po.x,po.y,po.z,tt, term); // Velocity of reference particle.
  #local scene_orig =
    object{ particle_with_arrow(po,vo, vmag,Ra, frp_o,txp_o, fsa,fra_o,txa_o) }
    
  // Circle around region of interest:
  #local frc = (term = 0 ? 1.0 : 0.5 );          // Extra minor radius factor for ring around region of interest.
  #local txc = texture{ tx_ring_circle }         // Texture for ring arrows.
  
  #local rc = frc*0.0040*Rc;
  #local scene_ring = 
    torus{ Rc,rc rotate 90*x texture{ txc } }
    
  // Testing arrow scaling:
  #local pt = < 0.10, 0.12, 0.00 >;            // Should be visible.
  #local vt = vmag*< cos(0.3), sin(0.3), 0 >;  // Velocity with magnitude {vmag}.
  #local rt = 0.02*Ra;                         // Halfthickness of test ring.
  
  #local pu = < 0.10, -0.12, 0.00 >;           // Should be visible.
  #local vu = < 0.30, -0.20, 0.00 >;         
  #local scene_test =
    union{
      object{ particle_with_arrow(pt,vt, vmag,Ra, 1.0,txo, fsa,fra_g,txo) } 
      torus{ Ra,rc rotate 90*x translate pt texture{ txo } }
      
      //object{ arrow(vu, 0.01, 0.08,0.02,0.05) translate pu texture{ txa_g } }
    }

  #local scene = 
    union{
      object{ scene_grid }
      object{ scene_orig }
      #if (term = 0)
        object{ scene_ring }
      #end
      //object{ scene_test }
    }
    
  object{ scene }
  
  #declare cam_ctr = < 0, 0, 0 >;
  #declare cam_rad = 1.45*Rv;
  #declare cam_dir = z;
  #declare cam_dst = 2000*cam_rad;
  #declare cam_shd = false;
  camlight(cam_ctr, cam_rad, cam_dir, cam_dst, z, 1.3, 3,20.0,cam_shd)
#end
