// Last edited on 2013-02-01 18:57:24 by stolfilocal
// Frame of a movie illustrating a component of the velocity gradient 

#include "velgrad.inc"

#macro frame(tt)
  // A frame of the movie at time {tt} (0 to 1).
  
  global_settings{ max_trace_level 30 }
  background{ color rgb < 1.000, 1.000, 1.000 > }

  
  #debug concat("FRAME - CLOCK = ", str(tt,6,4), " PHASE = ", str(tt,6,4), "\n")

  object{ velgrad_all(R,ra,rc,dr,ang,max_nr,top_nro,bot_nro,np_min,nlayers,tt) }
  
  #declare vlen = R*2*radians(ang);
  
  #declare cam_rad = 0.83*vlen; 
  #declare cam_ctr = < 0, 0, +0.00*vlen >; 
  #declare cam_dir = <2,3,2>; 
  #declare cam_dst = 2000*cam_rad;
  #declare cam_shd = false;
  camlight(cam_ctr, cam_rad, cam_dir, cam_dst, z, 1.3, 3,20.0,cam_shd)

#end
