// Last edited on 2013-02-01 18:57:31 by stolfilocal
// Snapshot of ring of particles around origin, 
// showing velocity vectors

#include "sample_ring.inc"
#include "field.inc"
#include "general_parameters.inc"

#macro subfig_flovel_ring(rel,ma,tt)
  // Snapshot of velocities on a ring of particles around origin, 
  // showing absolute ({rel=false}) or relative ({rel=true}) 
  // velocity vectors.

  #local crv = flow_crv;
  #local A = flow_A;
  #local B = flow_B;
  #local C = flow_C;
  #local D = flow_D;

  #local Rc = sample_circle_R; // Major radius of particle circle.

  #local Rf = 2.75*Rc;   // Half-width, half-height of figure.
  
  #local np = sample_circle_N;   // Number of particles in ring.
  #local rp = 0.075*Rc;  // Radius of particle.
  #local txpr = texture{ particle_tx }
  #local txpc = texture{ particle_center_tx }

  #local ra = 0.20*rp;  // Radius of arrows.
  #local txar = texture{ arrow_ring_tx }
  #local txac = texture{ arrow_center_tx }

  #local rc = 0.75*ra;           // Minor radius of particle circle.
  #local txc = sample_circle_tx; // Minor radius of particle circle.

  #local scene = 
    object{ sample_ring(crv,A,B,C,D, Rc,rc,txc, np,rp,txpr,txpc, ra,ma,txar,txac, rel,Rf) }
    
  object{ scene }
  
  #declare cam_ctr = < 0, 0, 0 >;
  #declare cam_rad = Rf;
  #declare cam_dir = z;
  #declare cam_dst = 2000*cam_rad;
  #declare cam_shd = false;
  camlight(cam_ctr, cam_rad, cam_dir, cam_dst, z, 1.3, 3,20.0,cam_shd)
#end

#macro subfig(tt)
  #local ma = flow_mag;     // Scale factor for arrow length.
  subfig_flovel_ring(false,ma,tt)
#end
