// Last edited on 2013-02-02 21:11:42 by stolfilocal
// Stresses on the surface of a spheroidal particle

#include "set_normals_icosahedron.inc"
#include "set_normals_dodecahedron.inc"
#include "set_normals_trunc_icosahedron.inc"
#include "set_normals_bitrunc_icosahedron.inc"
#include "stress_spiny_ball.inc"
#include "show_normals.inc"

#macro subfig(tt)
  #local show_uu = false;

  #local tx_dod = texture{ pigment{ color rgb <0.000,0.800,0.000> } finish { diffuse 0.3 ambient 0.7 } }
  #local tx_ico = texture{ pigment{ color rgb <1.000,0.200,0.000> } finish { diffuse 0.3 ambient 0.7 } }
  #local tx_tic = texture{ pigment{ color rgb <1.000,0.000,1.000> } finish { diffuse 0.3 ambient 0.7 } }
  #local tx_bti = texture{ pigment{ color rgb <1.000,1.000,0.000> } finish { diffuse 0.3 ambient 0.7 } }

  // Sampling normals:
  #local max_nu = 400;
  #local uu = array[max_nu];
  #local tu = array[max_nu];
  #local k = 0;
  #local k = set_normals_dodecahedron       (uu, tu, tx_dod, k);
  #local k = set_normals_icosahedron        (uu, tu, tx_ico, k);
  #local k = set_normals_trunc_icosahedron  (uu, tu, tx_tic, k);
  #local k = set_normals_bitrunc_icosahedron(uu, tu, tx_bti, k);
  #local nu = k;
  
  #local RP = 1.0;    // Radius of particle.
  #local RF = 1.0*RP; // Radius of fog ball.
  #local LA = 0.40*RP;             // Max field arrow length for scaling.
  #local mra = 0.75;               // Arrow thinning factor.
  #local LN = 0.00*RP;             // Length of normal arrows.
  #local srad = 0.65*sqrt(4.0/nu); // Angular radius of a patch (radians).
  #local scene =
    union{
      #if (show_uu)
        object{ show_normals(RP, uu, tu, nu) }
        object{ axes(1.25*RP) }
      #else
        object{ stress_spiny_ball(tt, RP,RF,srad,LA,mra,LN, uu, nu) }
      #end
    }
  
  #declare cam_ctr = < 0, 0, 0 >;
  #declare cam_rad = 2.15*RP;
  #declare cam_dir = < 3, 4, 2 >;
  #declare cam_dst = 8*cam_rad;
  #declare cam_shd = true;
  camlight(cam_ctr, cam_rad, cam_dir, cam_dst, z, 1.3, 3,40.0,cam_shd)

  union{ 
    object{ scene }
  }
#end
