// Last edited on 2013-02-02 21:34:19 by stolfilocal
// Definition of stress on a surfce element

#include "set_normals_icosahedron.inc"
#include "set_normals_dodecahedron.inc"
#include "set_normals_trunc_icosahedron.inc"
#include "stress_definition.inc"
// #include "show_normals.inc"

#macro subfig(tt)
  #local RP = 1.0; // Radius of particle.
  #local tx_ico = texture{ pigment{ color rgb <1.000,0.200,0.000> } finish { diffuse 0.8 ambient 0.2 } }
  #local tx_dod = texture{ pigment{ color rgb <0.000,0.800,0.000> } finish { diffuse 0.8 ambient 0.2 } }
  #local tx_tic = texture{ pigment{ color rgb <1.000,0.000,1.000> } finish { diffuse 0.8 ambient 0.2 } }

  // Two particles with force on common patch:
  #local LA = 2.00*RP;   // Max field arrow length for scaling.
  #local srad = 0.20*pi; // Angular radius of a patch (radians).
  #local nrng = 2;       // Number of arrow rings.
  #local mra = 1.00;     // Arrow thinning factor.
  #local uu = z;
  #local vf = 0.3*RP*vnormalize(< -9, +1, 5 >); 
  #local vs = vf/6; 
  #local scene =
    object{ stress_definition(RP,srad,LA,mra,nrng, vf,vs) }
  
  #declare cam_ctr = uu*RP*cos(srad);
  #declare cam_rad = 2.15*RP;
  #declare cam_dir = < 3.5, 2.0, 4.0 >;
  #declare cam_dst = 8*cam_rad;
  #declare cam_shd = true;
  camlight(cam_ctr, cam_rad, cam_dir, cam_dst, z, 1.3, 3,40.0,cam_shd)

  union{ 
    object{ scene }
    // object{ axes(0.75*cam_rad) }
  }
#end
