// Last edited on 2013-02-02 00:50:44 by stolfilocal

// Recommended colors:
#declare translucent_layer_color_0 = < 0.000, 0.880, 0.500 >; // 0.5830
#declare translucent_layer_color_1 = < 0.200, 0.715, 1.000 >; // 0.5970

// Recommended colors:
#declare translucent_layer_mix_dust = 0.65;
#declare translucent_layer_mix_glas = 0.12;

#macro translucent_layer_color(sp)
  // Recommended color for a nested layer
  // {sp} = layer depth (0 to 1).
  #local col0 = translucent_layer_color_0; 
  #local col1 = translucent_layer_color_1;
  #local col = rgb col0*(1-sp) + col1*sp;
  col
#end

#macro translucent_layer_texture(col,dust,glas,thru)
  // A translucent texture for nested layers
  // {col} = color.
  #debug "ENTER translucent_layer_texture\n"
  #local wht = <1,1,1>;
  
  #local col_dust = (1-dust)*wht + dust*col;
  
  #local col_glas = (1-glas)*wht + glas*col;
  #local tx = 
    texture{
      pigment{ color col_glas filter 0.98 }
      finish{ diffuse 0.00 reflection 0 ambient 0.00 specular 0.00 roughness 0.005 }
    }
    texture{
      pigment{ color col_dust transmit thru }
      finish{ diffuse 0.80 reflection 0 ambient 0.20 specular 0.00 roughness 0.005 }
    }
    texture{
      pigment{ color <1,1,1> filter 1 }
      finish{ diffuse 0.00 reflection 0 ambient 0.00 specular 0.3 roughness 0.005 }
    }
  #local bogus = 0;
  tx
  #debug "EXIT translucent_layer_texture\n"
#end


