// POVRAY description of the DCC "abacus" logo, fancy colors, ring base

global_settings{ max_trace_level 3 }

light_source {
  <+15.0000, +50.0000, +17.0000>
  color rgb < 0.90, 0.90, 0.90 >
} 

light_source {
  <-10.0000, +80.0000, -02.0000>
  color rgb < 0.30, 0.30, 0.30 >
} 

light_source {
  <-01.0000, +80.0000, -05.0000>
  color rgb < 0.30, 0.30, 0.30 >
} 

#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#include "dcc-wood-new.inc"

#declare bamboo_base_color = color rgb <0.80, 0.70, 0.60>;
#declare bamboo_vein_color = color rgb <0.40, 0.35, 0.20>;
#declare bamboo_color = bamboo_base_color;
#include "textures/bamboo.inc"

#include "textures/lacquers.inc"
#include "textures/metals.inc"

// background{ color rgb <0.00, 0.03, 0.20> }
// background{ color rgb <0.00, 0.00, 0.00> }
#include "background.inc"

// The babacus:

#declare abacus_frame_texture = texture{texture_wood}
#declare abacus_stick_texture = texture{texture_bamboo} 
#declare abacus_unit_slider_texture = texture{texture_lacquer_blue}
#declare abacus_unit_slider_interior = interior{}
#declare abacus_five_slider_texture = texture{texture_lacquer_red}
#declare abacus_five_slider_interior = interior{}

#include "dcc-std-abacus.inc"

#declare abacus_shift_Y = 0.20;

//  object{abacus 
//    translate <0.0, abacus_frame_thickness/2, 0.0> 
//    scale 2.0*5/6
//    translate <0.0, abacus_shift_Y, 0.0> 
//  }

// The ring base

#declare ring_i_texture = 
  texture{ texture_gold 
    normal {
      onion 0.1
      scale 0.030
      sine_wave
    }
  }
  
#declare ring_o_texture = 
  texture{ texture_silver 
    normal {
      onion 0.2
      scale 0.030
      triangle_wave
    }
  }

#declare ring_i_ridge_texture = texture{ texture_lacquer_blue }
#declare ring_m_ridge_texture = texture{ texture_lacquer_red }
#declare ring_o_ridge_texture = texture{ texture_lacquer_blue }

#declare ring_i_legend_texture = texture{ texture_lacquer_blue }
#declare ring_o_legend_texture = texture{ texture_lacquer_red }

#declare ring_i_radius = 2.1;
#declare ring_m_radius = 2.9;
#declare ring_o_radius = 3.41;

#declare ring_o_thickness = 0.250;
#declare ring_m_thickness = 0.300;
#declare ring_i_thickness = 0.275;

#declare ring_ridge_radius = 0.03;

#declare ring_legend_relief = 0.05;

#include "dcc-base-ring.inc"

#declare base_shift_Y = 0.00;

object{abacus_base
  translate <0.0, base_shift_Y, 0.0>
}

plane{ 
  <0,1,0>, -0.05 
  pigment{ color bgColor }
  finish{ ambient 0.0 diffuse 1.0 }
}

sky_sphere{
  pigment{ 
    gradient z
    color_map {
      [ 0.0 color rgb < 0.9, 0.9, 0.9 > ]
      [ 1.0 color rgb < 0.3, 0.3, 0.3 > ]
    }
    sine_wave
    scale 0.33
    translate -100
    rotate <0,27,0>
  }
}

#declare centerX = 0;
#declare centerY = 0;
#declare centerZ = 0;

#declare camDX = 0;
#declare camDY = 50;
#declare camDZ = 0;

#declare skyX = 0;
#declare skyY = 1;
#declare skyZ = 0;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+7.0000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +7.0000>
  sky       <skyX, skyY, skyZ>
  look_at   <centerX, centerY, centerZ>
} 

