// POVRAY description of the DCC "abacus" logo, fancy colors, ring base

global_settings{ max_trace_level 3 }

#include "dcc-lights-3.inc"

#include "fgstyle-1.inc"
#include "rgstyle-1.inc"

#include "background.inc"

// The babacus:

#include "dcc-std-abacus.inc"

#declare base_shift_Y = 0.00;
#declare abacus_shift_Y = 0.20;

object{abacus 
  translate <0.0, abacus_frame_thickness/2, 0.0> 
  scale 2.0*5/6
  translate <0.0, abacus_shift_Y, 0.0> 
}

// #include "test-balls.inc"

// The ring base

#include "dcc-std-base-ring.inc"

object{dcc_base_ring
  translate <0.0, base_shift_Y, 0.0>
}

plane{ 
  <0,1,0>, -0.05 
  pigment{ color bgColor }
  finish{ ambient 0.0 diffuse 1.0 }
}

//  sky_sphere{
//    pigment{ 
//      gradient z
//      color_map {
//        [ 0.0 color rgb < 0.9, 0.9, 0.9 > ]
//        [ 1.0 color rgb < 0.3, 0.3, 0.3 > ]
//      }
//      sine_wave
//      scale 0.33
//      translate -100
//      rotate <0,27,0>
//    }
//  }

sky_sphere{
  pigment{ color rgb < 0.9, 0.9, 0.9 > }
}

#declare centerX = 0;
#declare centerY = 0;
#declare centerZ = 0;

#declare camDX = 0;
#declare camDY = 50;
#declare camDZ = 0;

#declare skyX = 0;
#declare skyY = 1;
#declare skyZ = 0;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+7.0000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +7.0000>
  sky       <skyX, skyY, skyZ>
  look_at   <centerX, centerY, centerZ>
} 

