// POVRAY description of the DCC "abacus" logo, fancy colors
// Last edited on 2002-03-29 18:42:11 by stolfi

#include "background.inc"
#include "fgstyle-0.inc"

#include "dcc-view-1.inc"    // from front
#include "dcc-lights-1.inc"  // from front, mostly

#declare show_disk = 0;  // 1 to show the marble disk
#declare show_wall = 1;  // 1 to show the background plane (colored bgColor)

#declare abacus_bottom_Y = 0.0;
#declare base_top_Y = -0.1;

#include "dcc-std-abacus.inc"

#declare abacus_shift_Y = abacus_bottom_Y + abacus_frame_thickness/2;

object{ abacus translate <0.0, abacus_shift_Y, 0.0> }

//  #include "test-balls-abacus.inc"
//  object{ test_balls_abacus }

#if (show_wall)
  // The plain plane

  #declare matte_color = color bgColor;
  #include "textures/matte.inc"
  #declare base_texture = texture { texture_matte }

  #include "dcc-base-plane.inc"
#end

#if (show_disk)
  // The marble disk:

  #include "dcc-marbles.inc"

  #declare base_texture = texture{texture_marble_pink}

  #declare base_disk_thickness = 0.20;
  #declare base_disk_radius = 1.5;
  #include "dcc-base-disk.inc"
#end

#if (show_disk | show_wall)
  #declare base_shift_Y = base_top_Y;
  object{ abacus_base translate < 0.0, base_shift_Y, 0.0 > }
#end


