// Windows on the back wall (for specular surfaces)

// Requires
//
//   window_width
//   window_height
//   window_dist
//   window_min_Z
//
//   window_texture
//
// Defines
//
//   dcc_windows_back

#declare window_pane = box{ <0,0,0>, <1,1,1> }

#declare dcc_windows_back =
  union{
    object{ window_pane translate < 0.00, 0.00, 0.00 > }
    object{ window_pane translate < 1.05, 0.00, 0.00 > }
    object{ window_pane translate < 2.10, 0.00, 0.00 > }
    object{ window_pane translate < 0.00, 0.00, 1.05 > }
    object{ window_pane translate < 1.05, 0.00, 1.05 > }
    object{ window_pane translate < 2.10, 0.00, 1.05 > }
    texture{ window_texture }
    scale < window_width/3.10, 0.001, window_height/2.05 >
    translate < -window_width, window_dist, window_min_Z >
  }
