//  Requires
//
//    legend_text_up
//    legend_text_dn
//
//    legend_width
//    legend_radius
//    legend_depth
//
//    legend_texture
//
//    legend_font_file
//    legend_font_width
//    legend_font_height
//    legend_font_thickness
//    legend_font_gap
//

#declare dcc_ring_legend = sphere{ <0,0,0>, 0 }
#declare n_up = strlen(legend_text_up);
#declare n_dn = strlen(legend_text_dn);
#declare n = n_up + n_dn;

#declare xs = 2*3.1415926*legend_radius / n / (legend_font_width + legend_font_gap)
#declare ys = legend_depth / legend_font_thickness
#declare zs = legend_width / legend_font_height;
#declare dt = 360.0 / n;

#declare g_up = sphere{ <0,0,0>, 0 }
#declare tx = legend_text_up
#while (strlen(tx) > 0)
  #declare legend_char = substr(tx, 1, 1)
  #include "dcc-ring-legend-char.inc"
  #declare g_up =
    union{
      object{ g_up rotate -dt*y }
      object{ ch scale <xs,ys,zs> translate legend_radius*z }
    }
  #declare tx = substr(tx,2,strlen(tx)-1)
#end
#declare g_up = object{ g_up rotate ((n_up-1)/2.0)*dt*y }

#declare g_dn = sphere{ <0,0,0>, 0 }
#declare tx = legend_text_dn
#declare dt = 360.0 / n;
#while (strlen(tx) > 0)
  #declare legend_char = substr(tx, 1, 1)
  #include "dcc-ring-legend-char.inc"
  #declare g_dn =
    union{
      object{ g_dn rotate +dt*y }
      object{ ch scale <xs,ys,zs> translate -legend_radius*z }
    }
  #declare tx = substr(tx,2,strlen(tx)-1)
#end
#declare g_dn = object{ g_dn rotate -((n_dn-1)/2.0)*dt*y }

#declare dcc_ring_legend = 
  union{ 
    object{g_up} 
    object{g_dn} 
    texture{ legend_texture }
  }
    
