// Windows on the back wall (for specular surfaces)

// Requires
//
//   window_width
//   window_height
//   window_dist
//   window_min_Z
//
//   window_texture
//
// Defines
//
//   dcc_windows_back

#declare window_pane = box{ <0,0,0>, <1,1,1> }

#declare dcc_windows_back =
  union{
    object{ window_pane translate < 0.00, 0.00, 0.00 > }
    object{ window_pane translate < 1.10, 0.00, 0.00 > }
    object{ window_pane translate < 2.20, 0.00, 0.00 > }
    object{ window_pane translate < 0.00, 0.00, 1.10 > }
    object{ window_pane translate < 1.10, 0.00, 1.10 > }
    object{ window_pane translate < 2.20, 0.00, 1.10 > }
    object{ window_pane translate < 0.00, 0.00, 2.20 > }
    object{ window_pane translate < 1.10, 0.00, 2.20 > }
    object{ window_pane translate < 2.20, 0.00, 2.20 > }
    texture{ window_texture }
    scale < window_width/3.20, 0.001, window_height/3.20 >
    translate < -window_width, window_dist, window_min_Z >
  }
