background{ color rgb <0.00, 0.03, 0.20> }
#declare crystal_color = color rgb <1.00, 0.60, 0.25>;
#declare highlight_color = color rgb <1.00, 1.00, 1.00>;
#declare wood_texture =
  texture{
    pigment{
      wood
      turbulence 0.2
      color_map{ 
        [ 0.0, 0.8  
          color red 0.500 green 0.220 blue 0.053
          color red 0.500 green 0.220 blue 0.053
        ]
        [ 0.8, 1.01 
          color red 0.300 green 0.100 blue 0.040
          color red 0.200 green 0.033 blue 0.033
        ]
      }
      scale <0.5, 0.05, 0.05>
    }
    normal{
      wrinkles 0.2
      scale <0.01, 0.01, 0.5>
    }
    finish {diffuse 0.95 ambient 0.05}
    rotate <0, 90, 0>
  }
  texture{
    pigment{color highlight_color filter 0.80}
    normal{
      wrinkles 0.2
      scale <0.5, 0.01, 0.01>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.4 roughness 0.01}
  }
#declare light_bamboo_texture =
  texture{
    pigment{
      color rgb <0.80, 0.70, 0.60>
    }
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.95 ambient 0.05}
  }
#declare dark_bamboo_texture =
  texture{
    pigment{
      color rgb <0.30, 0.25, 0.15>
    }
    normal{
      wrinkles 0.2
      scale <0.01, 0.01, 0.50>
    }
    finish {diffuse 0.95 ambient 0.05}
    rotate <0, 90, 0>
  }
  texture{
    pigment{color highlight_color filter 0.80}
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.2 roughness 0.05}
  }
#declare red_lacquer_texture =
  texture{
    pigment{
      color rgb <0.90, 0.00, 0.15>
    }
    finish {diffuse 0.95 ambient 0.05}
  }
  texture{
    pigment{
      color rgb <0.90, 0.00, 0.15> filter 0.50
    }
    finish {diffuse 0 ambient 0 specular 1 roughness 0.05}
  }
  texture{
    pigment{color highlight_color filter 0.80}
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.3 roughness 0.01}
  }
#declare blue_lacquer_texture =
  texture{
    pigment{
      color rgb <0.00, 0.30, 0.60>
    }
    finish {diffuse 0.95 ambient 0.05}
  }
  texture{
    pigment{
      color rgb <0.00, 0.10, 0.20> filter 0.50
    }
    finish {diffuse 0 ambient 0 specular 1 roughness 0.05}
  }
  texture{
    pigment{color highlight_color filter 0.80}
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.3 roughness 0.01}
  }
#declare opaque_texture = 
    texture{
      pigment {color crystal_color filter 0.00}
      finish {diffuse 0.95 ambient 0.05}
    }
#declare crystal_texture = 
    texture{
      pigment {color crystal_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.01}
    }
#declare crystal_interior = interior{ ior 1.2 }
#declare marble_texture = 
  texture{
    pigment{marble
      turbulence 1
      color_map{
        [ 0.000, 0.800 
          color rgb <0.95, 0.40, 0.43>
          color rgb <1.00, 0.60, 0.65>
        ]
        [ 0.800, 1.001 
          color rgb <1.00, 0.60, 0.65>
          color rgb <1.00, 0.90, 0.91>
        ]
      }
      rotate <0,90,0>
    }
    finish{diffuse 0.95 ambient 0.05}
  }
  texture{
    pigment {color highlight_color filter 0.70}
    finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.01}
  }
#declare abacus_frame_texture = texture{wood_texture}
#declare abacus_stick_texture = texture{light_bamboo_texture} 
#declare abacus_unit_slider_texture = texture{blue_lacquer_texture}
#declare abacus_unit_slider_interior = interior{}
#declare abacus_five_slider_texture = texture{red_lacquer_texture}
#declare abacus_five_slider_interior = interior{}
#declare baseHY = 0.10;
#declare baseY = - (1 * abacus_frame_thickness/2);
#declare baseR = 1.5;
#declare base_texture = texture{marble_texture}
cylinder {
  <0.0, baseY-baseHY, 0.0>,
  <0.0, baseY+baseHY, 0.0>,
  baseR
  texture{base_texture}
}
#declare centerX = 0;
#declare centerY = baseY+baseHY;
#declare centerZ = 0;
