// background {  color rgb <0.90, 1.00, 0.92>  }
background {  color rgb <0.95, 0.95, 0.95>  }
#declare topaz_color    = color rgb <1.00, 0.60, 0.25>;
#declare ruby_color     = color rgb <1.00, 0.00, 0.30>;
#declare sapphire_color = color rgb <0.10, 0.30, 1.00>;
#declare emerald_color  = color rgb <0.05, 0.80, 0.00>;
#declare panther_color  = color rgb <1.00, 0.75, 0.80>;
#declare ivory_color    = color rgb <1.00, 0.97, 0.95>;
#declare gold_color     = color rgb <1.00, 0.90, 0.15>;
#declare silver_color   = color rgb <0.95, 0.97, 1.00>;
#declare highlight_color = color rgb <1.00, 1.00, 1.00>;
#declare topaz_texture = 
    texture{ 
      pigment { color topaz_color filter 1.00 }
      finish { diffuse 0.0 ambient 0.0 }
    }
    texture{ 
      pigment { color highlight_color filter 0.70 }
      finish { diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.005 }
    }
#declare topaz_interior = interior { ior 1.3 }
#declare ruby_texture = 
    texture{ 
      pigment { color ruby_color filter 1.00 }
      finish { diffuse 0.0 ambient 0.0 }
    }
    texture{ 
      pigment { color highlight_color filter 0.70 }
      finish { diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.005 }
    }
#declare ruby_interior = interior { ior 1.3 }
#declare sapphire_texture = 
    texture{ 
      pigment { color sapphire_color filter 1.00 }
      finish { diffuse 0.0 ambient 0.0 }
    }
    texture{ 
      pigment { color highlight_color filter 0.70 }
      finish { diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.005 }
    }
#declare sapphire_interior = interior { ior 1.3 }
#declare emerald_texture = 
    texture{ 
      pigment { color emerald_color filter 1.00 }
      finish { diffuse 0.0 ambient 0.0 }
    }
    texture{ 
      pigment { color highlight_color filter 0.70 }
      finish { diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.005 }
    }
#declare emerald_interior = interior { ior 1.3 }
#declare panther_texture = 
    texture{ 
      pigment { color panther_color filter 1.00 }
      finish { diffuse 0.0 ambient 0.0 }
    }
    texture{ 
      pigment { color highlight_color filter 0.70 }
      finish { diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.005 }
    }
#declare panther_interior = interior { ior 1.3 }
#declare ivory_texture = 
    texture{ 
      pigment { color ivory_color filter 0.00 }
      finish { diffuse 0.95 ambient 0.05 }
    }
    texture{ 
      pigment { color highlight_color filter 0.90 }
      finish { diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.005 }
    }
#declare marble_texture = 
  texture{ 
    pigment{ marble
      turbulence 1
      color_map{ 
        [ 0.000, 0.800 
          color rgb <0.85, 0.85, 0.80>
          color rgb <1.00, 1.00, 0.95>
        ]
        [ 0.800, 1.001 
          color rgb <1.00, 1.00, 0.95>
          color rgb <1.00, 1.00, 0.98>
        ]
      }
      rotate <0,90,0>
    }
    finish{ diffuse 0.95 ambient 0.05 }
  }
  texture{ 
    pigment { color highlight_color filter 0.70 }
    finish { diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.01 }
  }
#declare metal_finish =
  finish{ 
    metallic brilliance 6
    ambient 0.05
    diffuse 0.05
    phong 0.25 phong_size 80
  }
#declare gold_texture = 
  texture{ 
    pigment{ color rgb <1,1,1> }
    finish{ metal_finish reflection 0.90*gold_color  }
  }
#declare silver_texture = 
  texture{ 
    pigment{ color rgb <1,1,1> }
    finish{ metal_finish reflection 0.90*silver_color }
  }
#declare abacus_frame_texture = texture{ gold_texture }
#declare abacus_stick_texture = texture{ silver_texture } 
#declare abacus_unit_slider_texture = texture{ sapphire_texture }
#declare abacus_unit_slider_interior = interior{ sapphire_interior }
#declare abacus_five_slider_texture = texture{ ruby_texture }
#declare abacus_five_slider_interior = interior{ ruby_interior }
union{ 
    translate <0.00, 0.00, 0.05>
  }
  union{ 
    object{ abacus_slider 
      scale <0.20, 0.20, 0.20>
      translate <-0.66, 0.00, 0.00>
      texture{ sapphire_texture } interior{ sapphire_interior }
    }
    object{ abacus_slider 
      scale <0.20, 0.20, 0.20>
      translate <-0.22, 0.00, 0.00>
      texture{ topaz_texture } interior{ topaz_interior }
    }
    object{ abacus_slider 
      scale <0.20, 0.20, 0.20>
      translate <+0.22, 0.00, 0.00>
      texture{ emerald_texture } interior{ emerald_interior }
    }
    object{ abacus_slider 
      scale <0.20, 0.20, 0.20>
      translate <+0.66, 0.00, 0.00>
      texture{ ruby_texture } interior{ ruby_interior }
    }
    translate <0.00, 0.00, -(abacus_height/2 + abacus_frame_width + 0.20)>
  }
  sphere{ 
    <0,0,0>, 0.25
    translate <-(abacus_width/2 + 0.25), 0.25, 0>
    texture{ gold_texture }
  }
  sphere{ 
    <0,0,0>, 0.25
    translate <+(abacus_width/2 + 0.25), 0.25, 0>
    texture{ silver_texture }
  }
  rotate <0,180,0>
}
#declare baseHY = 0.10;
#declare baseY = - (2 * abacus_frame_thickness/2)
#declare baseR = 1.5;
#declare base_texture = texture{ marble_texture }
cylinder { 
  <0.0, baseY-baseHY, 0.0>,
  <0.0, baseY+baseHY, 0.0>,
  baseR
  texture{ base_texture }
}
#declare centerX = 0;
#declare centerY = baseY+baseHY
#declare centerZ = 0;
