// POVRAY description of the DCC "abacus" logo, fancy colors, ring base

global_settings{ max_trace_level 3 }

#include "fgstyle-9.inc"
#include "rgstyle-2.inc"

#include "background.inc"

// The babacus:

#declare base_bottom_Y = 0.00;
#declare abacus_bottom_Y = 0.20;

#include "dcc-std-abacus.inc"

object{abacus 
  translate <0.0, abacus_frame_thickness/2, 0.0> 
  scale 2.0*5/6
  translate <0.0, abacus_bottom_Y, 0.0> 
}

// #include "test-balls-abacus.inc"
// object{ test_balls_abacus }

// The ring base

#include "dcc-std-base-ring.inc"

object{dcc_base_ring
  translate <0.0, base_bottom_Y, 0.0>
}

// #include "test-balls-ring.inc"
// object{ test_balls_ring }


// The background plane

plane{ 
  <0,1,0>, -0.05 
  pigment{ color bgColor }
  finish{ diffuse 0.95 ambient 0.05 }
}

// The windows on the wall (for specular surfaces)

#declare window_width  = 800.0;
#declare window_height = 400.0;
#declare window_dist   = 600.0;
#declare window_min_Y  = 100.0;
#declare window_min_Z  = 200.0;

#include "dcc-windows-right.inc"
object{ dcc_windows_right }

// #include "dcc-windows-back.inc"
// object{ dcc_windows_back }

sky_sphere{
  pigment{ 
    gradient z
    color_map {
      [ 0.0 color rgb < 0.0, 0.0, 0.0 > ]
      [ 0.5 color rgb < 0.0, 0.0, 0.0 > ]
      [ 0.5 color rgb < 0.9, 0.9, 0.9 > ]
      [ 1.0 color rgb < 0.9, 0.9, 0.9 > ]
    }
    scale 3
    translate -1.65*z
    rotate <-32,0,0>
    rotate <0,27,0>
  }
}

// sky_sphere{
//   pigment{ color rgb < 0.9, 0.9, 0.9 > }
// }

#include "dcc-lights-6.inc"
#include "dcc-view-3.inc"
