// Last edited on 2024-05-26 21:46:56 by stolfi

#macro nut_collect_walk_edges(E, inner)
  // Returns an array {Ke[0..Nr-1][0..Nw-1]} such that {Ke[kr][0..Nw-1]}
  // are the indices of the edges in {E[1..Ne]} that are to walk around the 
  // bottom part of wall {kr}: outer wall if {inner=false},
  // inner wall if {inner=true}. 
  //
  // Currently, the edges in {Ke[kr][0..Nw-1]} are not in any particular order,
  // and their orientation is indeterminate.

  #local Ne = dimension_size(E, 1) - 1;

  #if (inner)
    #local Ty_min = 400; 
    #local Ty_max = 499;
  #else
    #local Ty_min = 300; 
    #local Ty_max = 399;
  #end

  #local Nr_max = Ty_max - Ty_min + 1;    // Max number of rotation indices.
  #local Nwr_max = 2000;                  // Max number of walk edges per wall.
  #local Nwr = array[Nr_max]              // {Nwr[kr]} is count of walk edges seen for each {kr}; 
  #local Ke_tmp = array[Nr_max][Nwr_max]  // Walk edge indices for wall {kr} are {Ke_tmp[kr][0..Nwr[kr]-1]}.
  #for (kr, 0, Nr_max-1)
    #local Nwr[kr] = 0;
    #for (kw, 0, Nwr_max-1)
      #local Ke_tmp[kr][kw] = -1;
    #end
  #end

  #for (ke, 1, Ne)
    #local Ty = E[ke].z;  // Edge type.
    #if ((Ty >= Ty_min) & (Ty <= Ty_max))
      #local kr = Ty - Ty_min; // Rotation (wall) index.
      #local Ke_tmp[kr][Nwr[kr]] = ke;
      #local Nwr[kr] = Nwr[kr] + 1;
      // #debug concat("!! {ke} = ", str(ke,0,0), " {kr} = ", str(kr,0,0), " {Nwr[kr]} = ", str(Nwr[kr],0,0), "\n")
    #end
  #end
  
  // Find number {Nr} of rotations and {Nw} of walk edges per rotation:
  #local Nr = 0;
  #local Nw = 0;
  #for (kr,0,Nr_max-1)
    #if (Nwr[kr] > 0) 
      #debug concat("!! {kr} = ", str(kr,0,0), " {Nwr[kr]} = ", str(Nwr[kr],0,0), "\n")
      #local Nr = kr + 1;
      #if (kr = 0) 
        #local Nw = Nwr[kr];
      #else
        #if (Nwr[kr] != Nwr[kr-1]) kaboom("{Nw} varies with {kr}") #end
      #end
    #end
  #end
  #if ((Nr = 0) | (Nw = 0)) kaboom("No walk edges?") #end
  
  // Copy {Ke_tmp} to a tight-sized array:
  #local Ke = array[Nr][Nw];
  #for (kr, 0, Nr-1) 
    #for (kw, 0, Nw-1) 
      #local Ke[kr][kw] = Ke_tmp[kr][kw];
    #end
  #end

  Ke
#end
