#! /bin/bash 

N08d="$1"; shift
SUBFIG="$1"; shift

QUICK=0
if [[ ${QUICK} -ne 0 ]]; then
  WIDTH=400
  HEIGHT=300
  NRAYS=1
else
  WIDTH=800
  HEIGHT=600
  NRAYS=2
fi

# Should images be displayed automatically?
SHOW=NO

# Should filter error messages (0 or 1):
FILTER=1

# Directories where POV-Ray is installed:
POVRAY=/usr/bin/povray
POVINC=( +L.. )

OPREF="out/${N08d}_${SUBFIG}"
PNGFILE=${OPREF}.png
POVFILE=nut_main.pov

# Command to display resultin image:
IMVIEW=( display -title '%d/%f' )

rm -f ${PNGFILE} params.inc
echo "#declare N08d = \"${N08d}\"" >> params.inc
echo "#declare subfig = ${SUBFIG};" >> params.inc
${POVRAY} \
    +K0.5000 \
    +FN +Q9 \
    +W${WIDTH} +H${HEIGHT} \
    +AM1 +A0.0 +R${NRAYS} \
    +D \
    ${POVINC[@]} \
    +I${POVFILE} \
    +O${PNGFILE} \
  2>&1 \
  | povray-output-filter.gawk -v do_filter=${FILTER}

if [[ "/${SHOW}" == "/YES" ]]; then
  if [[ -s ${PNGFILE} ]]; then
    ${IMVIEW[@]} ${PNGFILE}
  fi
fi
