// Last edited on 2024-05-26 21:19:28 by stolfi

#macro nut_collect_quines(E, inner)
  // Returns an array {Ke[0..Nr-1]} with the indices of
  // of the edges in {E[1..Ne]} that are quines: outer if {inner=false},
  // inner if {inner=true}. The index of {Ke} is the rotation number,
  // extracted from its type.  
  //
  // Note that the orientation of those edges is indeterminate.

  #local Ne = dimension_size(E, 1) - 1;

  #if (inner)
    #local Ty_min = 200; 
    #local Ty_max = 299;
  #else
    #local Ty_min = 100; 
    #local Ty_max = 199;
  #end

  #local Nr_max = Ty_max - Ty_min + 1; // Max number of rotation indices.
  #local Ke_tmp = array[Nr_max] // quine indices are {Ke_tmp[0..Nr-1]}
  #for (kr, 0, Nr_max-1) #local Ke_tmp[kr] = -1; #end

  #local Nr = 0; // Number of quines seen.
  #for (ke, 1, Ne)
    #local Ty = E[ke].z;  // Edge type.
    #if ((Ty >= Ty_min) & (Ty <= Ty_max))
      #local kr = Ty - Ty_min;
      #if (Ke_tmp[kr] != -1)
        #debug concat("!! dup ke = ", str(ke,0,0), " Ty = ", str(Ty,0,0), " Ke_tmp[kr] = ", str(Ke_tmp[kr],0,0), "\n")
        kaboom("Two quines with same {kr}")
      #end
      #local Ke_tmp[kr] = ke;
      #local Nr = Nr + 1;
    #end
  #end
  // Copy {Ke_tmp} to a tight-sized array:
  #local Ke = array[Nr];
  #for (kr, 0, Nr-1) 
    #if (Ke_tmp[kr] = -1)
      #debug concat("!! missing kr = ", str(kr,0,0), "\n")
      kaboom("No quine for some {kr}")
    #end
    #local Ke[kr] = Ke_tmp[kr];
  #end

  Ke
#end
