# Tools to generate G-code files from tool-paths.
# Last edited on 2021-02-18 21:27:36 by jstolfi

import gcode_IMP
import path
import move
import sys

def write(wr, oph, islice, parms):
  # Writes to file {wr} the G-code to extrude the oriented path {oph};
  # including the slice preamble and postamble.
  #
  # The path {oph} should include all necessary jumps so that the
  # starting point of each element (trace or jump) is the final point of
  # the previous element (if any)
  #
  # The procedure assumes that {islice} is the slice number, counted
  # from 0 at the bottom. The {parms} argument should be a python dict
  # containing the printer parameters.
  #
  # The file {wr} should be opened and closed by the caller.
  gcode_IMP.write(wr, oph, islice, parms)

def write_contents(wr, oph, parms):
  # Like {write}, but assumes that the slice preamble and postamble
  # are written by the client.
  gcode_IMP.write_contents(wr, oph, parms)

def compute_feed_length(p, q, parms):
  # Returns the length of filament needed to extrude a trace from {p} to {q}.
  return gcode_IMP.compute_feed_length(p, q, parms)

