#! /usr/bin/python3
# Test program for module {gcode}
# Last edited on 2021-02-19 14:48:39 by jstolfi

import gcode
import path
import move 
import hacks
import example_path
import job_parms
import rn
import pyx
import sys
from math import sqrt, sin, cos, floor, ceil, inf, nan, pi

parms = job_parms.typical()

pyx.unit.set(uscale=0.5, wscale=0.5, vscale=0.5)

def do_test(name, ph, strace, axes, matter):
  # Runs a test with the given {name} and {path}. Writes files
  # "tests/out/gcode_TST_{name}.{ext}" where {ext} is "eps", "png", and "jpg".
  #
  # If {axes} is true, plots trace axes too. 
  #
  # If {matter} is true, shows the estimated actual area covered
  # by the extruded material of traces.

  # Plot the path for reference:
  B = path.bbox(ph)
  c = pyx.canvas.canvas()
  plo = (floor(B[0][0])-1, floor(B[0][1])-1)
  phi = (ceil(B[1][0])+1, ceil(B[1][1])+1)
  xgrid = phi[0] - plo[0]
  ygrid = phi[1] - plo[1]
  hacks.plot_grid(c, None, 0.02, plo, xgrid, ygrid, 0,  1,1)

  ctrace =  pyx.color.rgb(0.050, 0.850, 0.000) # Color of nominal trace area.
  waxes =   0.05*strace; 
  axes = False
  dots = False
  arrows = False
  matter = True
  path.plot_standard(c, ph, (0,0), None, ctrace, waxes, axes, dots, arrows, matter)
  hacks.write_plot(c, "tests/out/gcode_TST_" + name)

  # Generate the G-code:
  gwr = open("tests/out/gcode_TST.gcode", "w")
  gcode.write(gwr, ph, 0, parms)
  gwr.close()

def test_simple():
  # Generates G-code for a simple path.
  name = "simple"
  ph = example_path.simple(parms)
  strace = parms['solid_raster_width']  # Distance between adjacent tracings.
  axes = True
  dots = True
  matter = True
  do_test(name, ph, strace, axes, matter)

def test_gearloose():
  # Generates G-code for a medium complexity path.
  name = "gearloose"
  R = 10
  ph = example_path.gearloose(R, True, parms)
  strace = parms['solid_raster_width']  # Distance between adjacent tracings.
  axes = False
  matter = False
  do_test(name, ph, strace, axes, matter)

test_simple()
test_gearloose()
