import plot_data

import path
import contour
import block
import contact

import gcode_write
import hacks
import rn

import os
import pyx

def plot_input(fname, CTRS, BS, CS, o, parms):
  pbox = rn.box_from_point(o)

  if len(CTRS) > 0:
    auxbox = contour.bbox(CTRS)
  else:
    auxbox = block.bbox(BS)
 
  pbox = rn.box_join(pbox, auxbox)
  pbox = hacks.round_box(pbox, 1)
  szx, szy = rn.box_size(pbox)
  sz_max = max(szx, szy)

  wblocks = 0.05*parms['solid_raster_width'] ; cblocks = hacks.trace_colors(len(BS)) # Blocks.
  wcontours = 0.05*parms['contour_trace_width'] ; ccontours = pyx.color.rgb( 0.000, 0.000, 0.000 ) # Contours.
  wcontacts = 0.15*parms['solid_raster_width'] ; ccontacts = [pyx.color.rgb( 0.000, 0.000, 0.000 ), None ]# Contacts.
  wstart = 1.3*parms['solid_raster_width'] ; cstart = pyx.color.rgb( 0.000, 0.000, 0.000 ) # Initial nozzle position.
  
  for ip in range(2):
    c = pyx.canvas.canvas()

    wd_frame = 0.003*sz_max
    hacks.plot_frame(c, pyx.color.rgb.black, 0.02, None, pbox, -0.75*wd_frame)

    wd_grid = 0.002*sz_max
    hacks.plot_grid(c, pyx.color.rgb(0.800, 0.750, 0.600), 0.03, None, pbox, +5*wd_grid, 1, 1)

    if CTRS != None:
      plot_contours(c, wcontours, ccontours, CTRS)
    
    if BS != None:
      plot_blocks(c, wblocks, cblocks, BS, ip)

    if CS != None:
      plot_contacts(c, CS, ccontacts, wcontacts)

    hacks.plot_line(c, cstart, wstart, o, o)
    hacks.write_plot(c, "%s_ip%02d" % (fname, ip))
    os.remove("%s_ip%02d" % (fname, ip) + '.eps')

  return [pbox, sz_max]

def plot_solution(fname, Q, c_box, test_parms, parms): 
  # Find the bounding box:
  pbox = c_box[0]
  sz_max = c_box[1]
  
  c = pyx.canvas.canvas()

  wd_frame = 0.003*sz_max
  hacks.plot_frame(c, pyx.color.rgb.white, 0.02, None, pbox, -0.75*wd_frame)

  wd_grid = 0.002*sz_max
  hacks.plot_grid(c, pyx.color.rgb(0.800, 0.750, 0.600), 0.03, None, pbox, +5*wd_grid, 1, 1)
  
  wtraces = 0.05*parms['solid_raster_width'] 

  moves_list = path.plot_standard(c, Q, None, wtraces)
  
  wpoint = 1.3*parms['solid_raster_width'] ; cpoint = pyx.color.rgb( 1.000, 0.000, 0.000 ) # Initial nozzle position.
  o = path.pini(Q)
  hacks.plot_line(c, cpoint, wpoint, o, o)

  cpoint = pyx.color.rgb( 0.000, 0.000, 1.000 ) # Final nozzle position.
  o = path.pfin(Q)
  hacks.plot_line(c, cpoint, wpoint, o, o)

  hacks.write_plot(c, fname)
  os.remove(fname + '.eps')

  gcode_write.write_slice(test_parms['gcode'], moves_list, test_parms, parms)

  return

def plot_debug(CTRS, BS, CS, Q, ncalls, c_box, parms):
  # Find the bounding box:
  pbox = c_box[0]
  sz_max = c_box[1]
  fname = c_box[2] + '_' + str(ncalls).zfill(7)
  
  c = pyx.canvas.canvas()

  wd_frame = 0.003*sz_max
  hacks.plot_frame(c, pyx.color.rgb.white, 0.02, None, pbox, -0.75*wd_frame)

  wd_grid = 0.002*sz_max
  hacks.plot_grid(c, pyx.color.rgb(0.800, 0.750, 0.600), 0.03, None, pbox, +5*wd_grid, 1, 1)  

  cpath = [ pyx.color.rgb( 0.000, 0.000, 0.000 ) ]*100
  wblocks = 0.05*parms['solid_raster_width'] ; cblocks = hacks.trace_colors(len(BS)) # Blocks.
  wcontours = 0.05*parms['contour_trace_width'] ; ccontours = pyx.color.rgb( 0.000, 0.000, 0.000 ) # Contours.
  wcontacts = 0.15*parms['solid_raster_width'] ; ccontacts = [pyx.color.rgb( 0.000, 0.000, 0.000 ), pyx.color.rgb( 1.000, 0.000, 0.000 ) ]# Contacts.
  
  path.plot_standard(c, Q, cpath, wblocks)

  if CTRS != None:
    plot_contours(c, wcontours, ccontours, CTRS)
  
  if BS != None:
    plot_blocks(c, wblocks, cblocks, BS, 0)

  if CS != None:
    plot_contacts(c, CS, ccontacts, wcontacts)

  hacks.write_plot(c, fname)
  os.remove(fname + '.eps')

  return


def plot_contours(c, wctrs, ccontours, CTRS, qEnd = None):
  for ctr in CTRS:
    if qEnd != None:
      ctr_path = contour.make_path(ctr, qEnd)
    else:
      ctr_path = contour.make_path_temp(ctr)

    path.plot_standard(c, ctr_path, ccontours, wctrs)

  return

def plot_blocks(c, wbtrs, ctraces, BS, ip):
  for ibc in range(len(BS)):
    bc = BS[ibc]
    block_path, d = block.choice(bc, ip)
    path.plot_standard(c, block_path, [ctraces[ibc]], wbtrs, d)
  return

def plot_contacts(c, CS, cconts, wconts):
  ccontso = cconts[1]
  cconts = cconts[0]

  for ct in CS:
    bc0 = contact.side_block(ct, 0)
    bc1 = contact.side_block(ct, 1)
    
    done0 = block.used(bc0)
    done1 = block.used(bc1)
    
    if (done0 == True and done1 == False) or (done0 == False and done1 == True):
      contact.plot(c, ct, None, clr = ccontso, wd_line = wconts, sz_tic = 0, arrow = False)
    elif done0 == False and done1 == False:
      contact.plot(c, ct, None, clr = cconts, wd_line = wconts, sz_tic = 0, arrow = False)
    
    rasterLink = contact.get_raster_link(ct)

    if rasterLink[0] != None:
      contact.plot_link(c, rasterLink[0], pyx.color.rgb( 0.000, 0.000, 0.000 ), 0.04)

    if rasterLink[1] != None:
      contact.plot_link(c, rasterLink[1], pyx.color.rgb( 0.000, 0.000, 0.000 ), 0.04)

  return